/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ui.BasicReplaceResultsPanel;
import org.netbeans.modules.search.ui.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.RequestProcessor;

public class RefreshAction
extends AbstractAction {
    private final MatchingObject mo;

    public RefreshAction(MatchingObject matchingObject) {
        super(Bundle.RefreshAction_name());
        this.mo = matchingObject;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mo != null) {
            RequestProcessor.getDefault().post(() -> {
                MatchingObject.Def def;
                FileObject fileObject = this.mo.getFileObject();
                if (!fileObject.isValid()) {
                    try {
                        fileObject = fileObject.getFileSystem().findResource(fileObject.getPath());
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Logger.getLogger(BasicReplaceResultsPanel.class.getName()).log(Level.FINE, null, fileStateInvalidException);
                    }
                }
                if (fileObject != null && fileObject.isValid() && (def = this.mo.getBasicComposition().getMatcher().check(fileObject, new SearchListener(){})) != null) {
                    this.mo.refresh(def);
                }
            });
        }
    }
}

