/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DistributedManager;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.manager.Constants;
import org.apache.catalina.manager.DummyProxySession;
import org.apache.catalina.manager.JspHelper;
import org.apache.catalina.manager.ManagerServlet;
import org.apache.catalina.manager.util.SessionUtils;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class HTMLManagerServlet
extends ManagerServlet {
    private static final long serialVersionUID = 1L;
    static final String APPLICATION_MESSAGE = "message";
    static final String APPLICATION_ERROR = "error";
    static final String sessionsListJspPath = "/WEB-INF/jsp/sessionsList.jsp";
    static final String sessionDetailJspPath = "/WEB-INF/jsp/sessionDetail.jsp";
    static final String connectorCiphersJspPath = "/WEB-INF/jsp/connectorCiphers.jsp";
    static final String connectorCertsJspPath = "/WEB-INF/jsp/connectorCerts.jsp";
    static final String connectorTrustedCertsJspPath = "/WEB-INF/jsp/connectorTrustedCerts.jsp";
    private boolean showProxySessions = false;
    private String htmlSubTitle = null;
    private static final String APPS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-left\"><small>{1}</small></td>\n <td class=\"header-left\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-left\"><small>{5}</small></td>\n <td class=\"header-left\"><small>{6}</small></td>\n</tr>\n";
    private static final String APPS_ROW_DETAILS_SECTION = "<tr>\n <td class=\"row-left\" bgcolor=\"{6}\" rowspan=\"2\"><small>{0}</small></td>\n <td class=\"row-left\" bgcolor=\"{6}\" rowspan=\"2\"><small>{1}</small></td>\n <td class=\"row-left\" bgcolor=\"{6}\" rowspan=\"2\"><small>{2}</small></td>\n <td class=\"row-center\" bgcolor=\"{6}\" rowspan=\"2\"><small>{3}</small></td>\n <td class=\"row-center\" bgcolor=\"{6}\" rowspan=\"2\"><small><a href=\"{4}\">{5}</a></small></td>\n";
    private static final String MANAGER_APP_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  &nbsp;{7}&nbsp;\n  </small>\n </td>\n</tr><tr>\n <td class=\"row-left\" bgcolor=\"{13}\">\n  <form method=\"POST\" action=\"{8}\">\n  <small>\n  &nbsp;<input type=\"submit\" value=\"{9}\">&nbsp;{10}&nbsp;<input type=\"text\" name=\"idle\" size=\"5\" value=\"{11}\">&nbsp;{12}&nbsp;\n  </small>\n  </form>\n </td>\n</tr>\n";
    private static final String STARTED_DEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\">\n  &nbsp;<small>{1}</small>&nbsp;\n  <form class=\"inline\" method=\"POST\" action=\"{2}\">  <small><input type=\"submit\" value=\"{3}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{4}\">  <small><input type=\"submit\" value=\"{5}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{6}\">  &nbsp;&nbsp;<small><input type=\"submit\" value=\"{7}\"></small>  </form>\n </td>\n </tr><tr>\n <td class=\"row-left\" bgcolor=\"{13}\">\n  <form method=\"POST\" action=\"{8}\">\n  <small>\n  &nbsp;<input type=\"submit\" value=\"{9}\">&nbsp;{10}&nbsp;<input type=\"text\" name=\"idle\" size=\"5\" value=\"{11}\">&nbsp;{12}&nbsp;\n  </small>\n  </form>\n </td>\n</tr>\n";
    private static final String STOPPED_DEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\" rowspan=\"2\">\n  <form class=\"inline\" method=\"POST\" action=\"{0}\">  <small><input type=\"submit\" value=\"{1}\"></small>  </form>\n  &nbsp;<small>{3}</small>&nbsp;\n  &nbsp;<small>{5}</small>&nbsp;\n  <form class=\"inline\" method=\"POST\" action=\"{6}\">  <small><input type=\"submit\" value=\"{7}\"></small>  </form>\n </td>\n</tr>\n<tr></tr>\n";
    private static final String STARTED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\">\n  &nbsp;<small>{1}</small>&nbsp;\n  <form class=\"inline\" method=\"POST\" action=\"{2}\">  <small><input type=\"submit\" value=\"{3}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{4}\">  <small><input type=\"submit\" value=\"{5}\"></small>  </form>\n  &nbsp;<small>{7}</small>&nbsp;\n </td>\n </tr><tr>\n <td class=\"row-left\" bgcolor=\"{13}\">\n  <form method=\"POST\" action=\"{8}\">\n  <small>\n  &nbsp;<input type=\"submit\" value=\"{9}\">&nbsp;{10}&nbsp;<input type=\"text\" name=\"idle\" size=\"5\" value=\"{11}\">&nbsp;{12}&nbsp;\n  </small>\n  </form>\n </td>\n</tr>\n";
    private static final String STOPPED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION = " <td class=\"row-left\" bgcolor=\"{13}\" rowspan=\"2\">\n  <form class=\"inline\" method=\"POST\" action=\"{0}\">  <small><input type=\"submit\" value=\"{1}\"></small>  </form>\n  &nbsp;<small>{3}</small>&nbsp;\n  &nbsp;<small>{5}</small>&nbsp;\n  &nbsp;<small>{7}</small>&nbsp;\n </td>\n</tr>\n<tr></tr>\n";
    private static final String DEPLOY_SECTION = "</table>\n<br>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployPath\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{4}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployVersion\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{5}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployConfig\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{6}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"deployWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{7}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n";
    private static final String UPLOAD_SECTION = "<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{0}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{1}\" enctype=\"multipart/form-data\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{2}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"file\" name=\"deployWar\" size=\"40\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{3}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br>\n\n";
    private static final String CONFIG_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"tlsHostName\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{4}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br>";
    private static final String DIAGNOSTICS_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{2}\">\n   <input type=\"submit\" value=\"{4}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{3}</small>\n </td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{5}</small></td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{6}\">\n   <input type=\"submit\" value=\"{7}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{8}</small>\n </td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{9}\">\n   <input type=\"submit\" value=\"{10}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{11}</small>\n </td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form method=\"post\" action=\"{12}\">\n   <input type=\"submit\" value=\"{13}\">\n  </form>\n </td>\n <td class=\"row-left\">\n  <small>{14}</small>\n </td>\n</tr>\n</table>\n<br>";

    @Override
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        String string2 = httpServletRequest.getParameter("path");
        ContextName contextName = null;
        if (string2 != null) {
            contextName = new ContextName(string2, httpServletRequest.getParameter("version"));
        }
        httpServletResponse.setContentType("text/html; charset=utf-8");
        String string3 = "";
        if (string != null && !string.equals("/") && !string.equals("/list")) {
            if (string.equals("/sessions")) {
                try {
                    if (contextName != null) {
                        this.doSessions(contextName, httpServletRequest, httpServletResponse, stringManager);
                        return;
                    }
                }
                catch (Exception exception) {
                    this.log(sm.getString("htmlManagerServlet.error.sessions", new Object[]{contextName}), exception);
                    string3 = stringManager.getString("managerServlet.exception", new Object[]{exception.toString()});
                }
            } else if (string.equals("/sslConnectorCiphers")) {
                this.sslConnectorCiphers(httpServletRequest, httpServletResponse, stringManager);
            } else if (string.equals("/sslConnectorCerts")) {
                this.sslConnectorCerts(httpServletRequest, httpServletResponse, stringManager);
            } else if (string.equals("/sslConnectorTrustedCerts")) {
                this.sslConnectorTrustedCerts(httpServletRequest, httpServletResponse, stringManager);
            } else {
                string3 = string.equals("/upload") || string.equals("/deploy") || string.equals("/reload") || string.equals("/undeploy") || string.equals("/expire") || string.equals("/start") || string.equals("/stop") ? stringManager.getString("managerServlet.postCommand", new Object[]{string}) : stringManager.getString("managerServlet.unknownCommand", new Object[]{string});
            }
        }
        this.list(httpServletRequest, httpServletResponse, string3, stringManager);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        String string2 = httpServletRequest.getParameter("path");
        ContextName contextName = null;
        if (string2 != null) {
            contextName = new ContextName(string2, httpServletRequest.getParameter("version"));
        }
        String string3 = httpServletRequest.getParameter("deployPath");
        String string4 = httpServletRequest.getParameter("deployWar");
        String string5 = httpServletRequest.getParameter("deployConfig");
        ContextName contextName2 = null;
        if (string3 != null && !string3.isEmpty()) {
            contextName2 = new ContextName(string3, httpServletRequest.getParameter("deployVersion"));
        } else if (string5 != null && !string5.isEmpty()) {
            contextName2 = ContextName.extractFromPath(string5);
        } else if (string4 != null && !string4.isEmpty()) {
            contextName2 = ContextName.extractFromPath(string4);
        }
        String string6 = httpServletRequest.getParameter("tlsHostName");
        httpServletResponse.setContentType("text/html; charset=utf-8");
        String string7 = "";
        if (string != null && !string.isEmpty()) {
            if (string.equals("/upload")) {
                string7 = this.upload(httpServletRequest, stringManager);
            } else if (string.equals("/deploy")) {
                string7 = this.deployInternal(string5, contextName2, string4, stringManager);
            } else if (string.equals("/reload")) {
                string7 = this.reload(contextName, stringManager);
            } else if (string.equals("/undeploy")) {
                string7 = this.undeploy(contextName, stringManager);
            } else if (string.equals("/expire")) {
                string7 = this.expireSessions(contextName, httpServletRequest, stringManager);
            } else if (string.equals("/start")) {
                string7 = this.start(contextName, stringManager);
            } else if (string.equals("/stop")) {
                string7 = this.stop(contextName, stringManager);
            } else if (string.equals("/findleaks")) {
                string7 = this.findleaks(stringManager);
            } else if (string.equals("/sslReload")) {
                string7 = this.sslReload(string6, stringManager);
            } else {
                this.doGet(httpServletRequest, httpServletResponse);
                return;
            }
        }
        this.list(httpServletRequest, httpServletResponse, string7, stringManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String upload(HttpServletRequest httpServletRequest, StringManager stringManager) {
        String string;
        block12: {
            string = "";
            try {
                File file;
                Part part = httpServletRequest.getPart("deployWar");
                if (part == null) {
                    string = stringManager.getString("htmlManagerServlet.deployUploadNoFile");
                    break block12;
                }
                String string2 = part.getSubmittedFileName();
                if (string2 == null || !string2.toLowerCase(Locale.ENGLISH).endsWith(".war")) {
                    string = stringManager.getString("htmlManagerServlet.deployUploadNotWar", new Object[]{string2});
                    break block12;
                }
                if (string2.lastIndexOf(92) >= 0) {
                    string2 = string2.substring(string2.lastIndexOf(92) + 1);
                }
                if (string2.lastIndexOf(47) >= 0) {
                    string2 = string2.substring(string2.lastIndexOf(47) + 1);
                }
                if ((file = new File(this.host.getAppBaseFile(), string2)).exists()) {
                    string = stringManager.getString("htmlManagerServlet.deployUploadWarExists", new Object[]{string2});
                    break block12;
                }
                ContextName contextName = new ContextName(string2, true);
                String string3 = contextName.getName();
                if (this.host.findChild(string3) != null && !this.isDeployed(string3)) {
                    string = stringManager.getString("htmlManagerServlet.deployUploadInServerXml", new Object[]{string2});
                    break block12;
                }
                if (this.tryAddServiced(string3)) {
                    try {
                        part.write(file.getAbsolutePath());
                    }
                    finally {
                        this.removeServiced(string3);
                    }
                    this.check(string3);
                    break block12;
                }
                string = stringManager.getString("managerServlet.inService", new Object[]{string3});
            }
            catch (Exception exception) {
                string = stringManager.getString("htmlManagerServlet.deployUploadFail", new Object[]{exception.getMessage()});
                this.log(string, exception);
            }
        }
        return string;
    }

    protected String deployInternal(String string, ContextName contextName, String string2, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.deploy(printWriter, string, contextName, string2, false, stringManager);
        return stringWriter.toString();
    }

    protected void list(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, StringManager stringManager) throws IOException {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        Object[] objectArray = new Object[]{this.getServletContext().getContextPath(), stringManager.getString("htmlManagerServlet.title")};
        if (this.htmlSubTitle != null) {
            objectArray[1] = String.valueOf(objectArray[1]) + "</font><br/><font size=\"+1\">" + this.htmlSubTitle;
        }
        printWriter.print(MessageFormat.format(Constants.HTML_HEADER_SECTION, objectArray));
        printWriter.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, objectArray));
        objectArray = new Object[3];
        objectArray[0] = stringManager.getString("htmlManagerServlet.messageLabel");
        objectArray[1] = string == null || string.isEmpty() ? "OK" : Escape.htmlElementContent((String)string);
        printWriter.print(MessageFormat.format(Constants.MESSAGE_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.manager"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/list"), stringManager.getString("htmlManagerServlet.list"), this.getServletContext().getContextPath() + "/" + stringManager.getString("htmlManagerServlet.helpHtmlManagerFile"), stringManager.getString("htmlManagerServlet.helpHtmlManager"), this.getServletContext().getContextPath() + "/" + stringManager.getString("htmlManagerServlet.helpManagerFile"), stringManager.getString("htmlManagerServlet.helpManager"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/status"), stringManager.getString("statusServlet.title")};
        printWriter.print(MessageFormat.format(Constants.MANAGER_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.appsTitle"), stringManager.getString("htmlManagerServlet.appsPath"), stringManager.getString("htmlManagerServlet.appsVersion"), stringManager.getString("htmlManagerServlet.appsName"), stringManager.getString("htmlManagerServlet.appsAvailable"), stringManager.getString("htmlManagerServlet.appsSessions"), stringManager.getString("htmlManagerServlet.appsTasks")};
        printWriter.print(MessageFormat.format(APPS_HEADER_SECTION, objectArray));
        Container[] containerArray = this.host.findChildren();
        Object[] objectArray2 = new String[containerArray.length];
        for (int i = 0; i < containerArray.length; ++i) {
            objectArray2[i] = containerArray[i].getName();
        }
        Arrays.sort(objectArray2);
        String string2 = stringManager.getString("htmlManagerServlet.appsStart");
        String string3 = stringManager.getString("htmlManagerServlet.appsStop");
        String string4 = stringManager.getString("htmlManagerServlet.appsReload");
        String string5 = stringManager.getString("htmlManagerServlet.appsUndeploy");
        String string6 = stringManager.getString("htmlManagerServlet.appsExpire");
        String string7 = "<i>" + stringManager.getString("htmlManagerServlet.noVersion") + "</i>";
        boolean bl = true;
        for (Object object : objectArray2) {
            boolean bl2;
            Context context = (Context)this.host.findChild((String)object);
            if (context == null) continue;
            bl = !bl;
            String string8 = bl ? "#C3F3C3" : "#FFFFFF";
            String string9 = context.getPath();
            String string10 = string9;
            if (string10.isEmpty()) {
                string10 = "/";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("path=");
            stringBuilder.append(URLEncoder.DEFAULT.encode(string10, StandardCharsets.UTF_8));
            String string11 = context.getWebappVersion();
            if (string11 != null && !string11.isEmpty()) {
                stringBuilder.append("&version=");
                stringBuilder.append(URLEncoder.DEFAULT.encode(string11, StandardCharsets.UTF_8));
            }
            String string12 = stringBuilder.toString();
            try {
                bl2 = this.isDeployed((String)object);
            }
            catch (Exception exception) {
                bl2 = false;
            }
            objectArray = new Object[7];
            objectArray[0] = "<a href=\"" + URLEncoder.DEFAULT.encode(string9 + "/", StandardCharsets.UTF_8) + "\" rel=\"noopener noreferrer\">" + Escape.htmlElementContent((String)string10) + "</a>";
            objectArray[1] = string11 == null || string11.isEmpty() ? string7 : Escape.htmlElementContent((String)string11);
            objectArray[2] = context.getDisplayName() == null ? "&nbsp;" : Escape.htmlElementContent((String)context.getDisplayName());
            objectArray[3] = context.getState().isAvailable();
            objectArray[4] = Escape.htmlElementContent((String)httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/sessions?" + string12));
            Manager manager = context.getManager();
            objectArray[5] = manager instanceof DistributedManager && this.showProxySessions ? Integer.valueOf(((DistributedManager)((Object)manager)).getActiveSessionsFull()) : (manager != null ? Integer.valueOf(manager.getActiveSessions()) : Integer.valueOf(0));
            objectArray[6] = string8;
            printWriter.print(MessageFormat.format(APPS_ROW_DETAILS_SECTION, objectArray));
            objectArray = new Object[]{Escape.htmlElementContent((String)httpServletResponse.encodeURL(httpServletRequest.getContextPath() + "/html/start?" + string12)), string2, Escape.htmlElementContent((String)httpServletResponse.encodeURL(httpServletRequest.getContextPath() + "/html/stop?" + string12)), string3, Escape.htmlElementContent((String)httpServletResponse.encodeURL(httpServletRequest.getContextPath() + "/html/reload?" + string12)), string4, Escape.htmlElementContent((String)httpServletResponse.encodeURL(httpServletRequest.getContextPath() + "/html/undeploy?" + string12)), string5, Escape.htmlElementContent((String)httpServletResponse.encodeURL(httpServletRequest.getContextPath() + "/html/expire?" + string12)), string6, stringManager.getString("htmlManagerServlet.expire.explain"), manager == null ? stringManager.getString("htmlManagerServlet.noManager") : Integer.valueOf(context.getSessionTimeout()), stringManager.getString("htmlManagerServlet.expire.unit"), string8};
            if (context.getName().equals(this.context.getName())) {
                printWriter.print(MessageFormat.format(MANAGER_APP_ROW_BUTTON_SECTION, objectArray));
                continue;
            }
            if (context.getState().isAvailable() && bl2) {
                printWriter.print(MessageFormat.format(STARTED_DEPLOYED_APPS_ROW_BUTTON_SECTION, objectArray));
                continue;
            }
            if (context.getState().isAvailable() && !bl2) {
                printWriter.print(MessageFormat.format(STARTED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION, objectArray));
                continue;
            }
            if (!context.getState().isAvailable() && bl2) {
                printWriter.print(MessageFormat.format(STOPPED_DEPLOYED_APPS_ROW_BUTTON_SECTION, objectArray));
                continue;
            }
            printWriter.print(MessageFormat.format(STOPPED_NONDEPLOYED_APPS_ROW_BUTTON_SECTION, objectArray));
        }
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.deployTitle"), stringManager.getString("htmlManagerServlet.deployServer"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/deploy"), stringManager.getString("htmlManagerServlet.deployPath"), stringManager.getString("htmlManagerServlet.deployVersion"), stringManager.getString("htmlManagerServlet.deployConfig"), stringManager.getString("htmlManagerServlet.deployWar"), stringManager.getString("htmlManagerServlet.deployButton")};
        printWriter.print(MessageFormat.format(DEPLOY_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.deployUpload"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/upload"), stringManager.getString("htmlManagerServlet.deployUploadFile"), stringManager.getString("htmlManagerServlet.deployButton")};
        printWriter.print(MessageFormat.format(UPLOAD_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.configTitle"), stringManager.getString("htmlManagerServlet.configSslReloadTitle"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/sslReload"), stringManager.getString("htmlManagerServlet.configSslHostName"), stringManager.getString("htmlManagerServlet.configReloadButton")};
        printWriter.print(MessageFormat.format(CONFIG_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.diagnosticsTitle"), stringManager.getString("htmlManagerServlet.diagnosticsLeak"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/findleaks"), stringManager.getString("htmlManagerServlet.diagnosticsLeakWarning"), stringManager.getString("htmlManagerServlet.diagnosticsLeakButton"), stringManager.getString("htmlManagerServlet.diagnosticsSsl"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/sslConnectorCiphers"), stringManager.getString("htmlManagerServlet.diagnosticsSslConnectorCipherButton"), stringManager.getString("htmlManagerServlet.diagnosticsSslConnectorCipherText"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/sslConnectorCerts"), stringManager.getString("htmlManagerServlet.diagnosticsSslConnectorCertsButton"), stringManager.getString("htmlManagerServlet.diagnosticsSslConnectorCertsText"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/sslConnectorTrustedCerts"), stringManager.getString("htmlManagerServlet.diagnosticsSslConnectorTrustedCertsButton"), stringManager.getString("htmlManagerServlet.diagnosticsSslConnectorTrustedCertsText")};
        printWriter.print(MessageFormat.format(DIAGNOSTICS_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlManagerServlet.serverTitle"), stringManager.getString("htmlManagerServlet.serverVersion"), stringManager.getString("htmlManagerServlet.serverJVMVersion"), stringManager.getString("htmlManagerServlet.serverJVMVendor"), stringManager.getString("htmlManagerServlet.serverOSName"), stringManager.getString("htmlManagerServlet.serverOSVersion"), stringManager.getString("htmlManagerServlet.serverOSArch"), stringManager.getString("htmlManagerServlet.serverHostname"), stringManager.getString("htmlManagerServlet.serverIPAddress")};
        printWriter.print(MessageFormat.format(Constants.SERVER_HEADER_SECTION, objectArray));
        objectArray = new Object[8];
        objectArray[0] = ServerInfo.getServerInfo();
        objectArray[1] = System.getProperty("java.runtime.version");
        objectArray[2] = System.getProperty("java.vm.vendor");
        objectArray[3] = System.getProperty("os.name");
        objectArray[4] = System.getProperty("os.version");
        objectArray[5] = System.getProperty("os.arch");
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            objectArray[6] = inetAddress.getHostName();
            objectArray[7] = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            objectArray[6] = "-";
            objectArray[7] = "-";
        }
        printWriter.print(MessageFormat.format(Constants.SERVER_ROW_SECTION, objectArray));
        printWriter.print(Constants.HTML_TAIL_SECTION);
        printWriter.flush();
        printWriter.close();
    }

    protected String reload(ContextName contextName, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.reload(printWriter, contextName, stringManager);
        return stringWriter.toString();
    }

    protected String undeploy(ContextName contextName, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.undeploy(printWriter, contextName, stringManager);
        return stringWriter.toString();
    }

    protected String sessions(ContextName contextName, int n, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sessions(printWriter, contextName, n, stringManager);
        return stringWriter.toString();
    }

    protected String start(ContextName contextName, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, contextName, stringManager);
        return stringWriter.toString();
    }

    protected String stop(ContextName contextName, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, contextName, stringManager);
        return stringWriter.toString();
    }

    protected String findleaks(StringManager stringManager) {
        StringBuilder stringBuilder = new StringBuilder();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.findleaks(false, printWriter, stringManager);
        String string = stringWriter.toString();
        if (!string.isEmpty()) {
            if (!string.startsWith("FAIL -")) {
                stringBuilder.append(stringManager.getString("htmlManagerServlet.findleaksList"));
            }
            stringBuilder.append(string);
        } else {
            stringBuilder.append(stringManager.getString("htmlManagerServlet.findleaksNone"));
        }
        return stringBuilder.toString();
    }

    protected String sslReload(String string, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.sslReload(printWriter, string, stringManager);
        return stringWriter.toString();
    }

    protected void sslConnectorCiphers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringManager stringManager) throws ServletException, IOException {
        httpServletRequest.setAttribute("cipherList", this.getConnectorCiphers(stringManager));
        this.getServletContext().getRequestDispatcher(connectorCiphersJspPath).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected void sslConnectorCerts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringManager stringManager) throws ServletException, IOException {
        httpServletRequest.setAttribute("certList", this.getConnectorCerts(stringManager));
        this.getServletContext().getRequestDispatcher(connectorCertsJspPath).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected void sslConnectorTrustedCerts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringManager stringManager) throws ServletException, IOException {
        httpServletRequest.setAttribute("trustedCertList", this.getConnectorTrustedCerts(stringManager));
        this.getServletContext().getRequestDispatcher(connectorTrustedCertsJspPath).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public String getServletInfo() {
        return "HTMLManagerServlet, Copyright (c) 1999-2025, The Apache Software Foundation";
    }

    @Override
    public void init() throws ServletException {
        super.init();
        String string = this.getServletConfig().getInitParameter("showProxySessions");
        this.showProxySessions = Boolean.parseBoolean(string);
        this.htmlSubTitle = this.getServletConfig().getInitParameter("htmlSubTitle");
    }

    protected String expireSessions(ContextName contextName, HttpServletRequest httpServletRequest, StringManager stringManager) {
        int n = -1;
        String string = httpServletRequest.getParameter("idle");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("managerServlet.error.idleParam", new Object[]{string}));
            }
        }
        return this.sessions(contextName, n, stringManager);
    }

    protected void doSessions(ContextName contextName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringManager stringManager) throws ServletException, IOException {
        httpServletRequest.setAttribute("path", (Object)contextName.getPath());
        httpServletRequest.setAttribute("version", (Object)contextName.getVersion());
        String string = httpServletRequest.getParameter("action");
        if (this.debug >= 1) {
            this.log("sessions: Session action '" + string + "' for web application '" + contextName.getDisplayName() + "'");
        }
        if ("sessionDetail".equals(string)) {
            String string2 = httpServletRequest.getParameter("sessionId");
            this.displaySessionDetailPage(httpServletRequest, httpServletResponse, contextName, string2, stringManager);
            return;
        }
        if ("invalidateSessions".equals(string)) {
            String[] stringArray = httpServletRequest.getParameterValues("sessionIds");
            int n = this.invalidateSessions(contextName, stringArray, stringManager);
            httpServletRequest.setAttribute(APPLICATION_MESSAGE, (Object)(Integer.toString(n) + " sessions invalidated."));
        } else if ("removeSessionAttribute".equals(string)) {
            String string3;
            String string4 = httpServletRequest.getParameter("sessionId");
            boolean bl = this.removeSessionAttribute(contextName, string4, string3 = httpServletRequest.getParameter("attributeName"), stringManager);
            String string5 = bl ? "Session attribute '" + string3 + "' removed." : "Session did not contain any attribute named '" + string3 + "'";
            httpServletRequest.setAttribute(APPLICATION_MESSAGE, (Object)string5);
            this.displaySessionDetailPage(httpServletRequest, httpServletResponse, contextName, string4, stringManager);
            return;
        }
        this.displaySessionsListPage(contextName, httpServletRequest, httpServletResponse, stringManager);
    }

    protected List<Session> getSessionsForName(ContextName contextName, StringManager stringManager) {
        if (contextName == null || !contextName.getPath().startsWith("/") && !contextName.getPath().isEmpty()) {
            String string = null;
            if (contextName != null) {
                string = contextName.getPath();
            }
            throw new IllegalArgumentException(stringManager.getString("managerServlet.invalidPath", new Object[]{Escape.htmlElementContent((String)string)}));
        }
        Context context = (Context)this.host.findChild(contextName.getName());
        if (null == context) {
            throw new IllegalArgumentException(stringManager.getString("managerServlet.noContext", new Object[]{Escape.htmlElementContent((String)contextName.getDisplayName())}));
        }
        Manager manager = context.getManager();
        ArrayList<Session> arrayList = new ArrayList<Session>(Arrays.asList(manager.findSessions()));
        if (manager instanceof DistributedManager && this.showProxySessions) {
            Set<String> set = ((DistributedManager)((Object)manager)).getSessionIdsFull();
            for (Session object : arrayList) {
                set.remove(object.getId());
            }
            for (String string : set) {
                arrayList.add(new DummyProxySession(string));
            }
        }
        return arrayList;
    }

    protected Session getSessionForNameAndId(ContextName contextName, String string, StringManager stringManager) {
        List<Session> list = this.getSessionsForName(contextName, stringManager);
        if (list.isEmpty()) {
            return null;
        }
        for (Session session : list) {
            if (!session.getId().equals(string)) continue;
            return session;
        }
        return null;
    }

    protected void displaySessionsListPage(ContextName contextName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringManager stringManager) throws ServletException, IOException {
        List<Session> list = this.getSessionsForName(contextName, stringManager);
        String string = httpServletRequest.getParameter("sort");
        String string2 = null;
        if (null != string && !string.trim().isEmpty()) {
            Comparator<Session> comparator = this.getComparator(string);
            if (comparator != null) {
                string2 = httpServletRequest.getParameter("order");
                if ("DESC".equalsIgnoreCase(string2)) {
                    comparator = Collections.reverseOrder(comparator);
                    string2 = "ASC";
                } else {
                    string2 = "DESC";
                }
                try {
                    list.sort(comparator);
                }
                catch (IllegalStateException illegalStateException) {
                    httpServletRequest.setAttribute(APPLICATION_ERROR, (Object)"Can't sort session list: one session is invalidated");
                }
            } else {
                this.log(sm.getString("htmlManagerServlet.error.sortOrder", new Object[]{string}));
            }
        }
        httpServletRequest.setAttribute("sort", (Object)string);
        httpServletRequest.setAttribute("order", string2);
        httpServletRequest.setAttribute("activeSessions", list);
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        httpServletResponse.setDateHeader("Expires", 0L);
        this.getServletContext().getRequestDispatcher(sessionsListJspPath).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected void displaySessionDetailPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ContextName contextName, String string, StringManager stringManager) throws ServletException, IOException {
        Session session = this.getSessionForNameAndId(contextName, string, stringManager);
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletRequest.setAttribute("currentSession", (Object)session);
        this.getServletContext().getRequestDispatcher(httpServletResponse.encodeURL(sessionDetailJspPath)).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    protected int invalidateSessions(ContextName contextName, String[] stringArray, StringManager stringManager) {
        if (null == stringArray) {
            return 0;
        }
        int n = 0;
        for (String string : stringArray) {
            Session session = this.getSessionForNameAndId(contextName, string, stringManager);
            if (null == session) {
                if (this.debug < 1) continue;
                this.log("Cannot invalidate null session " + string);
                continue;
            }
            try {
                session.getSession().invalidate();
                ++n;
                if (this.debug < 1) continue;
                this.log("Invalidating session id " + string);
            }
            catch (IllegalStateException illegalStateException) {
                if (this.debug < 1) continue;
                this.log("Cannot invalidate already invalidated session id " + string);
            }
        }
        return n;
    }

    protected boolean removeSessionAttribute(ContextName contextName, String string, String string2, StringManager stringManager) {
        boolean bl;
        block4: {
            Session session = this.getSessionForNameAndId(contextName, string, stringManager);
            if (null == session) {
                if (this.debug >= 1) {
                    this.log("Cannot remove attribute '" + string2 + "' for null session " + string);
                }
                return false;
            }
            HttpSession httpSession = session.getSession();
            bl = null != httpSession.getAttribute(string2);
            try {
                httpSession.removeAttribute(string2);
            }
            catch (IllegalStateException illegalStateException) {
                if (this.debug < 1) break block4;
                this.log("Cannot remote attribute '" + string2 + "' for invalidated session id " + string);
            }
        }
        return bl;
    }

    protected Comparator<Session> getComparator(String string) {
        if ("CreationTime".equalsIgnoreCase(string)) {
            return Comparator.comparingLong(Session::getCreationTime);
        }
        if ("id".equalsIgnoreCase(string)) {
            return HTMLManagerServlet.comparingNullable(Session::getId);
        }
        if ("LastAccessedTime".equalsIgnoreCase(string)) {
            return Comparator.comparingLong(Session::getLastAccessedTime);
        }
        if ("MaxInactiveInterval".equalsIgnoreCase(string)) {
            return Comparator.comparingInt(Session::getMaxInactiveInterval);
        }
        if ("new".equalsIgnoreCase(string)) {
            return Comparator.comparing(session -> session.getSession().isNew());
        }
        if ("locale".equalsIgnoreCase(string)) {
            return Comparator.comparing(JspHelper::guessDisplayLocaleFromSession);
        }
        if ("user".equalsIgnoreCase(string)) {
            return HTMLManagerServlet.comparingNullable(JspHelper::guessDisplayUserFromSession);
        }
        if ("UsedTime".equalsIgnoreCase(string)) {
            return Comparator.comparingLong(SessionUtils::getUsedTimeForSession);
        }
        if ("InactiveTime".equalsIgnoreCase(string)) {
            return Comparator.comparingLong(SessionUtils::getInactiveTimeForSession);
        }
        if ("TTL".equalsIgnoreCase(string)) {
            return Comparator.comparingLong(SessionUtils::getTTLForSession);
        }
        return null;
    }

    private static <U extends Comparable<? super U>> Comparator<Session> comparingNullable(Function<Session, ? extends U> function) {
        return (session, session2) -> {
            Comparable comparable = (Comparable)function.apply((Session)session);
            Comparable comparable2 = (Comparable)function.apply((Session)session2);
            return comparable == null ? (comparable2 == null ? 0 : -1) : (comparable2 == null ? 1 : comparable.compareTo(comparable2));
        };
    }
}

