/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXCellAlignList;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.AlignSpan;
import com.dickimawbooks.texparserlib.latex.Begin;
import com.dickimawbooks.texparserlib.latex.Cr;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.MultiCell;
import com.dickimawbooks.texparserlib.latex.TabularNewline;
import java.io.IOException;
import java.util.ArrayDeque;

public class AlignRow
extends DataObjectList {
    private TeXObjectList alignSpanList;

    public AlignRow() {
    }

    public AlignRow(int n) {
        super(n);
    }

    public AlignRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this();
        this.parse(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList createList() {
        return new AlignRow(this.capacity());
    }

    protected void parse(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXParserListener teXParserListener = teXParser.getListener();
        this.alignSpanList = new TeXObjectList();
        while (true) {
            if ((teXObject = TeXParserUtils.resolve(teXObjectList.popStack(teXParser), teXParser)) == null) {
                teXParser.debugMessage(1, "Unexpected null pointer while parsing AlignRow for span. STACK: " + teXObjectList + " PARSER: " + teXParser);
                break;
            }
            if (teXObject instanceof WhiteSpace) continue;
            if (!(teXObject instanceof AlignSpan)) {
                teXObjectList.push(teXObject);
                break;
            }
            if (teXObject instanceof TeXObjectList) {
                this.alignSpanList.addAll((TeXObjectList)teXObject);
                continue;
            }
            this.alignSpanList.add(teXObject);
        }
        teXObject = null;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        while (true) {
            Object object;
            TeXObject teXObject2;
            if ((teXObject2 = TeXParserUtils.resolve(teXObjectList.popStack(teXParser), teXParser)) == null) {
                teXParser.debugMessage(1, "Unexpected null pointer while parsing AlignRow. STACK: " + teXObjectList + " PARSER: " + teXParser);
                break;
            }
            if (teXObject2 instanceof Tab) {
                if (teXObject == null) {
                    this.add(teXParserListener.createGroup());
                    continue;
                }
                this.add(teXObject);
                teXObject = null;
                continue;
            }
            if (teXObject2 instanceof Cr) {
                if (teXObject == null) {
                    this.add(teXParserListener.createGroup());
                } else {
                    this.add(teXObject);
                    teXObject = null;
                }
                this.add(teXObject2 instanceof TabularNewline ? teXObject2 : teXParserListener.getControlSequence("tabularnewline"));
                break;
            }
            if (teXObject2 instanceof Begin) {
                object = TeXParserUtils.popLabelString(teXParser, teXObjectList);
                arrayDeque.push((String)object);
                this.add(teXObject2);
                this.add(teXParserListener.createGroup((String)object));
                continue;
            }
            if (teXObject2 instanceof End) {
                object = TeXParserUtils.popLabelString(teXParser, teXObjectList);
                if (arrayDeque.size() == 0) {
                    teXObjectList.push(teXParserListener.createGroup((String)object));
                    teXObjectList.push(teXObject2);
                    break;
                }
                arrayDeque.pop();
                this.add(teXObject2);
                this.add(teXParserListener.createGroup((String)object));
                continue;
            }
            if (teXObject2 instanceof MultiCell) {
                object = TeXParserUtils.expandOnce(teXObject2, teXParser, teXObjectList);
                if (teXObject == null) {
                    teXObject = teXParserListener.createGroup();
                }
                ((TeXObjectList)teXObject).add((TeXObject)object, true);
                continue;
            }
            if (teXObject == null) {
                teXObject = teXParserListener.createGroup();
            }
            ((TeXObjectList)teXObject).add(teXObject2);
        }
        if (teXObject != null) {
            this.add(teXObject);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        TeXCellAlignList teXCellAlignList = teXSettings.getAlignmentList();
        if (teXCellAlignList == null) {
            throw new LaTeXSyntaxException(teXParser, "latex.error.no_alignment", new Object[0]);
        }
        this.startRow(teXParser, teXObjectList);
        teXSettings.startRow();
        boolean bl = true;
        while (this.size() > 0) {
            TeXObject teXObject;
            Group group;
            TeXObject teXObject2 = TeXParserUtils.resolve(this.pop(), teXParser);
            if (teXObject2 instanceof TabularNewline) {
                this.endRow(teXParser, teXObjectList);
                bl = false;
                TeXParserUtils.process(teXObject2, teXParser, teXObjectList);
                continue;
            }
            int n = teXSettings.getAlignmentColumn();
            TeXCellAlign teXCellAlign = (TeXCellAlign)teXCellAlignList.get(n);
            teXParser.getSettings().startColumn();
            if (teXObject2 instanceof Group) {
                group = (Group)teXObject2;
            } else {
                group = teXParser.getListener().createGroup();
                group.add(teXObject2);
            }
            int n2 = 0;
            TeXObject teXObject3 = teXObject = group.isEmpty() ? group : group.peekStack();
            if (teXObject instanceof MultiCell) {
                n2 = ((MultiCell)teXObject).getColumnSpan();
            }
            this.processCell(teXParser, teXObjectList, teXCellAlign, group);
            for (int i = 1; i < n2; ++i) {
                teXParser.getSettings().startColumn();
            }
        }
        if (bl) {
            this.endRow(teXParser, teXObjectList);
        }
    }

    protected void startRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
    }

    protected void endRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
    }

    protected void processCell(TeXParser teXParser, TeXObjectList teXObjectList, TeXCellAlign teXCellAlign, Group group) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            group.process(teXParser, this);
        } else {
            StackMarker stackMarker = new StackMarker();
            this.add(stackMarker);
            this.addAll(teXObjectList);
            teXObjectList.clear();
            group.process(teXParser, this);
            for (int i = 0; i < this.size(); ++i) {
                TeXObject teXObject = (TeXObject)this.get(i);
                if (teXObject != stackMarker) continue;
                for (int j = i + 1; j < this.size(); ++j) {
                    teXObjectList.add((TeXObject)this.get(j));
                }
                this.setSize(i);
            }
        }
    }

    public TeXObjectList getAlignSpanList() {
        return this.alignSpanList;
    }
}

