/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.generic;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class ParAlign
extends Declaration {
    private int align;
    private int orgAlign;

    public ParAlign(String string, int n) {
        super(string);
        this.align = n;
        this.orgAlign = -1;
    }

    public static void addCommands(TeXParser teXParser) {
        teXParser.putControlSequence(new ParAlign("centering", 3));
        teXParser.putControlSequence(new ParAlign("raggedright", 1));
        teXParser.putControlSequence(new ParAlign("raggedleft", 2));
        teXParser.putControlSequence(new ParAlign("center", 3));
        teXParser.putControlSequence(new ParAlign("flushright", 2));
        teXParser.putControlSequence(new ParAlign("flushleft", 1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgAlign = teXSettings.getCurrentParAlign();
        teXSettings.setParAlign(this.align);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setParAlign(this.orgAlign);
    }

    @Override
    public Object clone() {
        return new ParAlign(this.getName(), this.align);
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public boolean isModeSwitcher() {
        return false;
    }
}

