\name{FFTPadImageFilter}
\alias{FFTPadImageFilter}
\title{FFTPadImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Pad an image to make it suitable for an FFT transformation.
FFTPadImageFilter}
\details{
FFT filters usually requires a specific image size. The size is
decomposed in several prime factors, and the filter only supports
prime factors up to a maximum value. This filter automatically finds
the greatest prime factor required by the available implementation and
pads the input appropriately.
This code was adapted from the Insight Journal contribution:
"FFT Based Convolution" by Gaetan Lehmann https://www.insight-journal.org/browse/publication/717
Gaetan Lehmann
See:
FFTShiftImageFilter
FFTPad for the procedural interface
itk::FFTPadImageFilter for the Doxygen on the original ITK class.
FFTPadImageFilter}
%C++ includes: sitkFFTPadImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ FFTPadImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{int GetSizeGreatestPrimeFactor() const:}{
Set/Get the greatest prime factor allowed on the size of the padded
image. The filter increase the size of the image to reach a size with
the greatest prime factor smaller or equal to the specified value. The
default value is 13, which is the greatest prime number for which the
FFT are precomputed in FFTW, and thus gives very good performance. A
greatest prime factor of 2 produce a size which is a power of 2, and
thus is suitable for vnl base fft filters. A greatest prime factor of
1 or less - typically 0 - disable the extra padding.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetSizeGreatestPrimeFactor(int SizeGreatestPrimeFactor):}{
Set/Get the greatest prime factor allowed on the size of the padded
image. The filter increase the size of the image to reach a size with
the greatest prime factor smaller or equal to the specified value. The
default value is 13, which is the greatest prime number for which the
FFT are precomputed in FFTW, and thus gives very good performance. A
greatest prime factor of 2 produce a size which is a power of 2, and
thus is suitable for vnl base fft filters. A greatest prime factor of
1 or less - typically 0 - disable the extra padding.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FFTPadImageFilter():}{
Destructor
}
}
}
