# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Union, Iterable
from typing_extensions import Literal, Required, TypeAlias, TypedDict

from .response_input_file_param import ResponseInputFileParam
from .response_input_text_param import ResponseInputTextParam
from .response_input_image_param import ResponseInputImageParam

__all__ = ["ResponseCustomToolCallOutputParam", "OutputOutputContentList"]

OutputOutputContentList: TypeAlias = Union[ResponseInputTextParam, ResponseInputImageParam, ResponseInputFileParam]


class ResponseCustomToolCallOutputParam(TypedDict, total=False):
    call_id: Required[str]
    """The call ID, used to map this custom tool call output to a custom tool call."""

    output: Required[Union[str, Iterable[OutputOutputContentList]]]
    """
    The output from the custom tool call generated by your code. Can be a string or
    an list of output content.
    """

    type: Required[Literal["custom_tool_call_output"]]
    """The type of the custom tool call output. Always `custom_tool_call_output`."""

    id: str
    """The unique ID of the custom tool call output in the OpenAI platform."""
