/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthUtils;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;

public class DayPattern {
    private final String id;
    private final String yearKeyA;
    private final String yearKeyB;
    private final String yearKeyC;
    private final String monthKeyA;
    private final String monthKeyB;
    private final String monthKeyC;
    private final String dayKeyA;
    private final String dayKeyB;
    private final String dayKeyC;

    public DayPattern(String id) {
        this.id = id;
        this.yearKeyA = "AYEAR" + id;
        this.yearKeyB = "BYEAR" + id;
        this.yearKeyC = "CYEAR" + id;
        this.monthKeyA = "AMONTH" + id;
        this.monthKeyB = "BMONTH" + id;
        this.monthKeyC = "CMONTH" + id;
        this.dayKeyA = "ADAY" + id;
        this.dayKeyB = "BDAY" + id;
        this.dayKeyC = "CDAY" + id;
    }

    public IRegex toRegex() {
        return new RegexOr(this.toRegexA_DD_MONTH_YYYY(), this.toRegexB_YYYY_MM_DD(), this.toRegexC_MONTH_DD_YYYY());
    }

    public Day getDay(RegexResult arg) {
        if (arg.get(this.dayKeyA, 0) != null) {
            return this.resultA(arg);
        }
        if (arg.get(this.dayKeyB, 0) != null) {
            return this.resultB(arg);
        }
        if (arg.get(this.dayKeyC, 0) != null) {
            return this.resultC(arg);
        }
        return null;
    }

    private IRegex toRegexA_DD_MONTH_YYYY() {
        return new RegexConcat(new RegexLeaf(1, this.dayKeyA, "([\\d]{1,2})"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf(1, this.monthKeyA, "(" + MonthUtils.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf(1, this.yearKeyA, "([\\d]{1,4})"));
    }

    private Day resultA(RegexResult arg) {
        int day = Integer.parseInt(arg.get(this.dayKeyA, 0));
        String month = arg.get(this.monthKeyA, 0);
        int year = Integer.parseInt(arg.get(this.yearKeyA, 0));
        return Day.create(year, month, day);
    }

    private IRegex toRegexB_YYYY_MM_DD() {
        return new RegexConcat(new RegexLeaf(1, this.yearKeyB, "([\\d]{1,4})"), new RegexLeaf("\\D"), new RegexLeaf(1, this.monthKeyB, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf(1, this.dayKeyB, "([\\d]{1,2})"));
    }

    private Day resultB(RegexResult arg) {
        int day = Integer.parseInt(arg.get(this.dayKeyB, 0));
        int month = Integer.parseInt(arg.get(this.monthKeyB, 0));
        int year = Integer.parseInt(arg.get(this.yearKeyB, 0));
        return Day.create(year, month, day);
    }

    private IRegex toRegexC_MONTH_DD_YYYY() {
        return new RegexConcat(new RegexLeaf(1, this.monthKeyC, "(" + MonthUtils.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf(1, this.dayKeyC, "([\\d]{1,2})"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf(1, this.yearKeyC, "([\\d]{1,4})"));
    }

    private Day resultC(RegexResult arg) {
        int day = Integer.parseInt(arg.get(this.dayKeyC, 0));
        String month = arg.get(this.monthKeyC, 0);
        int year = Integer.parseInt(arg.get(this.yearKeyC, 0));
        return Day.create(year, month, day);
    }
}

