/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ImplicitNode extends Base {

	public ImplicitNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the identifier of the node
	 *
	 * @return the identifier
	 * @throws Lib3MFException
	 */
	public String getIdentifier() throws Lib3MFException {
		Pointer bytesNeededIdentifier = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getidentifier.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededIdentifier, null}));
		int sizeIdentifier = bytesNeededIdentifier.getInt(0);
		Pointer bufferIdentifier = new Memory(sizeIdentifier);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getidentifier.invokeInt(new java.lang.Object[]{mHandle, sizeIdentifier, bytesNeededIdentifier, bufferIdentifier}));
		return new String(bufferIdentifier.getByteArray(0, sizeIdentifier - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the identifier of the node
	 *
	 * @param identifier the identifier
	 * @throws Lib3MFException
	 */
	public void setIdentifier(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_setidentifier.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier}));
	}

	/**
	 * Retrieves the display name of the node
	 *
	 * @return the display name
	 * @throws Lib3MFException
	 */
	public String getDisplayName() throws Lib3MFException {
		Pointer bytesNeededDisplayName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getdisplayname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededDisplayName, null}));
		int sizeDisplayName = bytesNeededDisplayName.getInt(0);
		Pointer bufferDisplayName = new Memory(sizeDisplayName);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getdisplayname.invokeInt(new java.lang.Object[]{mHandle, sizeDisplayName, bytesNeededDisplayName, bufferDisplayName}));
		return new String(bufferDisplayName.getByteArray(0, sizeDisplayName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the display name of the node
	 *
	 * @param displayName the display name
	 * @throws Lib3MFException
	 */
	public void setDisplayName(String displayName) throws Lib3MFException {
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_setdisplayname.invokeInt(new java.lang.Object[]{mHandle, bufferDisplayName}));
	}

	/**
	 * Retrieves the tag of the node
	 *
	 * @return the tag
	 * @throws Lib3MFException
	 */
	public String getTag() throws Lib3MFException {
		Pointer bytesNeededTag = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_gettag.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededTag, null}));
		int sizeTag = bytesNeededTag.getInt(0);
		Pointer bufferTag = new Memory(sizeTag);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_gettag.invokeInt(new java.lang.Object[]{mHandle, sizeTag, bytesNeededTag, bufferTag}));
		return new String(bufferTag.getByteArray(0, sizeTag - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the tag of the node
	 *
	 * @param tag the tag
	 * @throws Lib3MFException
	 */
	public void setTag(String tag) throws Lib3MFException {
		byte[] bytesTag = tag.getBytes(StandardCharsets.UTF_8);
		Memory bufferTag = new Memory(bytesTag.length + 1);
		bufferTag.write(0, bytesTag, 0, bytesTag.length);
		bufferTag.setByte(bytesTag.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_settag.invokeInt(new java.lang.Object[]{mHandle, bufferTag}));
	}

	/**
	 * Retrieves the type of the node
	 *
	 * @return the type of the node
	 * @throws Lib3MFException
	 */
	public Lib3MFWrapper.ImplicitNodeType getNodeType() throws Lib3MFException {
		Pointer bufferType = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getnodetype.invokeInt(new java.lang.Object[]{mHandle, bufferType}));
		return Lib3MFWrapper.EnumConversion.convertConstToImplicitNodeType(bufferType.getInt(0));
	}

	/**
	 * Add an input
	 *
	 * @param identifier the identifier of the input
	 * @param displayName the display name of the input
	 * @return 
	 * @throws Lib3MFException
	 */
	public ImplicitPort addInput(String identifier, String displayName) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		Pointer bufferPort = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_addinput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferDisplayName, bufferPort}));
		Pointer valuePort = bufferPort.getPointer(0);
		ImplicitPort port = null;
		if (valuePort == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Port was a null pointer");
		}
		port = mWrapper.PolymorphicFactory(valuePort, ImplicitPort.class);
		return port;
	}

	/**
	 * Retrieves the inputs
	 *
	 * @return the iterator for the inputs
	 * @throws Lib3MFException
	 */
	public ImplicitPortIterator getInputs() throws Lib3MFException {
		Pointer bufferIterator = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getinputs.invokeInt(new java.lang.Object[]{mHandle, bufferIterator}));
		Pointer valueIterator = bufferIterator.getPointer(0);
		ImplicitPortIterator iterator = null;
		if (valueIterator == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Iterator was a null pointer");
		}
		iterator = mWrapper.PolymorphicFactory(valueIterator, ImplicitPortIterator.class);
		return iterator;
	}

	/**
	 * Add an output
	 *
	 * @param identifier the identifier of the output
	 * @param displayName the display name of the output
	 * @return 
	 * @throws Lib3MFException
	 */
	public ImplicitPort addOutput(String identifier, String displayName) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		Pointer bufferPort = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_addoutput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferDisplayName, bufferPort}));
		Pointer valuePort = bufferPort.getPointer(0);
		ImplicitPort port = null;
		if (valuePort == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Port was a null pointer");
		}
		port = mWrapper.PolymorphicFactory(valuePort, ImplicitPort.class);
		return port;
	}

	/**
	 * Retrieves the outputs
	 *
	 * @return the iterator the outputs
	 * @throws Lib3MFException
	 */
	public ImplicitPortIterator getOutputs() throws Lib3MFException {
		Pointer bufferIterator = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_getoutputs.invokeInt(new java.lang.Object[]{mHandle, bufferIterator}));
		Pointer valueIterator = bufferIterator.getPointer(0);
		ImplicitPortIterator iterator = null;
		if (valueIterator == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Iterator was a null pointer");
		}
		iterator = mWrapper.PolymorphicFactory(valueIterator, ImplicitPortIterator.class);
		return iterator;
	}

	/**
	 * Retrieves an input
	 *
	 * @param identifier the identifier of the input
	 * @return the input port
	 * @throws Lib3MFException
	 */
	public ImplicitPort findInput(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		Pointer bufferInput = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_findinput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferInput}));
		Pointer valueInput = bufferInput.getPointer(0);
		ImplicitPort input = null;
		if (valueInput != Pointer.NULL) {
		  input = mWrapper.PolymorphicFactory(valueInput, ImplicitPort.class);
		}
		return input;
	}

	/**
	 * Retrieves an output
	 *
	 * @param identifier the identifier of the output
	 * @return the output port
	 * @throws Lib3MFException
	 */
	public ImplicitPort findOutput(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		Pointer bufferOutput = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_findoutput.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier, bufferOutput}));
		Pointer valueOutput = bufferOutput.getPointer(0);
		ImplicitPort output = null;
		if (valueOutput != Pointer.NULL) {
		  output = mWrapper.PolymorphicFactory(valueOutput, ImplicitPort.class);
		}
		return output;
	}

	/**
	 * Checks if the types of the input and output ports are valid for the node type
	 *
	 * @return true, if the types are valid
	 * @throws Lib3MFException
	 */
	public boolean areTypesValid() throws Lib3MFException {
		Pointer bufferValid = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitnode_aretypesvalid.invokeInt(new java.lang.Object[]{mHandle, bufferValid}));
		return bufferValid.getByte(0) != 0;
	}


}

