/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousInitializerSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "lazyDelegation", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getLazyDelegation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "isEnumEntryInitializer", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUninitializedEnumChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUninitializedEnumChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,272:1\n84#2:273\n44#2:275\n37#3:274\n1761#4,3:276\n808#4,11:279\n808#4,11:290\n808#4,11:301\n808#4,11:315\n543#4,6:330\n543#4,6:336\n315#5,3:312\n318#5,4:326\n*S KotlinDebug\n*F\n+ 1 FirUninitializedEnumChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUninitializedEnumChecker\n*L\n88#1:273\n92#1:275\n88#1:274\n109#1:276,3\n116#1:279,11\n117#1:290,11\n118#1:301,11\n121#1:315,11\n124#1:330,6\n141#1:336,6\n119#1:312,3\n119#1:326,4\n*E\n"})
public final class FirUninitializedEnumChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirUninitializedEnumChecker INSTANCE = new FirUninitializedEnumChecker();

    private FirUninitializedEnumChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirAnonymousFunction lazyDelegation;
        FirBasedSymbol<?> firBasedSymbol;
        FirBasedSymbol accessedContext;
        Map enumEntriesInitBlocks;
        List enumEntries;
        List enumInitBlocks;
        List enumMemberProperties;
        FirBasedSymbol calleeSymbol;
        KtSourceElement source;
        block35: {
            FirBasedSymbol<?> firBasedSymbol2;
            FirBasedSymbol<?> it;
            FirBasedSymbol<?> element$iv;
            ListIterator<FirBasedSymbol<?>> iterator$iv;
            boolean $i$f$lastOrNull;
            List<FirBasedSymbol<?>> $this$lastOrNull$iv;
            block34: {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                void $this$filterIsInstanceTo$iv$iv3;
                boolean isInsideCorrespondingEnum;
                Object it2;
                FirRegularClassSymbol enumClassSymbol;
                block33: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ProperUninitializedEnumEntryAccessAnalysis)) {
                        return;
                    }
                    KtSourceElement ktSourceElement = expression2.getSource();
                    if (ktSourceElement == null) {
                        return;
                    }
                    source = ktSourceElement;
                    if (source.getKind() instanceof KtFakeSourceElementKind) {
                        return;
                    }
                    FirBasedSymbol firBasedSymbol3 = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression2.getCalleeReference(), false, 1, null);
                    if (firBasedSymbol3 == null) {
                        return;
                    }
                    calleeSymbol = firBasedSymbol3;
                    FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(calleeSymbol);
                    FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                    if (firRegularClassSymbol == null) {
                        return;
                    }
                    enumClassSymbol = firRegularClassSymbol;
                    FirClassSymbol $this$isEnumClass$iv = enumClassSymbol;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
                        return;
                    }
                    FirClassLikeSymbol $this$visibility$iv = enumClassSymbol;
                    boolean $i$f$getVisibility = false;
                    if (Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Local.INSTANCE) && calleeSymbol instanceof FirEnumEntrySymbol) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeSymbol, null, 16, null);
                    }
                    Iterable $this$any$iv = context2.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it2 = (FirBasedSymbol)element$iv2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(it2), enumClassSymbol)) continue;
                            bl = true;
                            break block33;
                        }
                        bl = isInsideCorrespondingEnum = false;
                    }
                }
                if (!isInsideCorrespondingEnum) {
                    return;
                }
                List<FirBasedSymbol<?>> declarationSymbols = enumClassSymbol.getDeclarationSymbols();
                Iterable $this$filterIsInstance$iv = declarationSymbols;
                boolean $i$f$filterIsInstance = false;
                it2 = $this$filterIsInstance$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                    if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                enumMemberProperties = (List)destination$iv$iv;
                Iterable $this$filterIsInstance$iv2 = declarationSymbols;
                boolean $i$f$filterIsInstance2 = false;
                destination$iv$iv = $this$filterIsInstance$iv2;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof FirAnonymousInitializerSymbol)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                enumInitBlocks = (List)destination$iv$iv2;
                Iterable $this$filterIsInstance$iv3 = declarationSymbols;
                boolean $i$f$filterIsInstance3 = false;
                destination$iv$iv2 = $this$filterIsInstance$iv3;
                Object destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterIsInstanceTo3 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FirEnumEntrySymbol)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List $this$flatAssociateBy$iv = enumEntries = (List)destination$iv$iv3;
                boolean $i$f$flatAssociateBy = false;
                Object $this$flatAssociateBy_u24lambda_u240$iv = destination$iv$iv3 = MapsKt.createMapBuilder();
                boolean bl = false;
                for (Object value$iv : $this$flatAssociateBy$iv) {
                    List list;
                    List list2;
                    FirEnumEntrySymbol it3 = (FirEnumEntrySymbol)value$iv;
                    boolean bl3 = false;
                    Object object = it3.getInitializerObjectSymbol();
                    if (object != null && (object = ((FirClassSymbol)object).getDeclarationSymbols()) != null) {
                        void $this$filterIsInstanceTo$iv$iv4;
                        Iterable $this$filterIsInstance$iv4 = (Iterable)object;
                        boolean $i$f$filterIsInstance4 = false;
                        Iterable iterable = $this$filterIsInstance$iv4;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo4 = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv4) {
                            if (!(element$iv$iv instanceof FirAnonymousInitializerSymbol)) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        list2 = (List)destination$iv$iv4;
                    } else {
                        list2 = list = null;
                    }
                    if (list2 == null) {
                        list = CollectionsKt.emptyList();
                    }
                    for (Object key$iv : (Collection)list) {
                        $this$flatAssociateBy_u24lambda_u240$iv.put(key$iv, value$iv);
                    }
                }
                enumEntriesInitBlocks = MapsKt.build(destination$iv$iv3);
                $this$lastOrNull$iv = context2.getContainingDeclarations();
                $i$f$lastOrNull = false;
                iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = element$iv = iterator$iv.previous();
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(it), enumClassSymbol) || enumEntriesInitBlocks.containsKey(it))) continue;
                    firBasedSymbol2 = element$iv;
                    break block34;
                }
                firBasedSymbol2 = null;
            }
            FirBasedSymbol firBasedSymbol4 = firBasedSymbol2;
            if (firBasedSymbol4 == null) {
                return;
            }
            accessedContext = firBasedSymbol4;
            $this$lastOrNull$iv = context2.getContainingDeclarations();
            $i$f$lastOrNull = false;
            iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = element$iv = iterator$iv.previous();
                boolean bl = false;
                boolean bl5 = it instanceof FirCallableSymbol ? FirDeclarationUtilKt.isNonLocal(it) || ((FirCallableSymbol)it).getDispatchReceiverType() != null : false;
                if (!bl5) continue;
                firBasedSymbol = element$iv;
                break block35;
            }
            firBasedSymbol = null;
        }
        FirBasedSymbol containingDeclarationForAccess = firBasedSymbol;
        if (CollectionsKt.contains(enumMemberProperties, accessedContext) && (lazyDelegation = this.getLazyDelegation((FirPropertySymbol)accessedContext)) != null) {
            return;
        }
        if (CollectionsKt.contains(enumEntries, accessedContext)) {
            FirBasedSymbol firBasedSymbol5 = containingDeclarationForAccess;
            if (!(firBasedSymbol5 != null ? this.isEnumEntryInitializer(firBasedSymbol5) : false)) {
                return;
            }
        }
        if (CollectionsKt.contains(enumEntries, calleeSymbol)) {
            FirEnumEntrySymbol calleeEnumEntry = (FirEnumEntrySymbol)calleeSymbol;
            FirBasedSymbol firBasedSymbol6 = accessedContext;
            if (CollectionsKt.contains(enumMemberProperties, firBasedSymbol6) || CollectionsKt.contains(enumInitBlocks, firBasedSymbol6)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeEnumEntry, null, 16, null);
            } else if (CollectionsKt.contains(enumEntries, firBasedSymbol6)) {
                FirUninitializedEnumChecker.check$reportIllegalAccessInEnumEntry(enumEntries, calleeEnumEntry, context2, reporter, source, (FirEnumEntrySymbol)accessedContext);
            } else if (enumEntriesInitBlocks.containsKey(firBasedSymbol6)) {
                FirEnumEntrySymbol entrySymbol = (FirEnumEntrySymbol)MapsKt.getValue(enumEntriesInitBlocks, (FirAnonymousInitializerSymbol)accessedContext);
                if (Intrinsics.areEqual(entrySymbol, calleeSymbol)) {
                    return;
                }
                FirUninitializedEnumChecker.check$reportIllegalAccessInEnumEntry(enumEntries, calleeEnumEntry, context2, reporter, source, entrySymbol);
            }
        }
    }

    private final FirAnonymousFunction getLazyDelegation(FirPropertySymbol $this$lazyDelegation) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$lazyDelegation, FirResolvePhase.BODY_RESOLVE);
        FirProperty property2 = (FirProperty)$this$lazyDelegation.getFir();
        if (property2.getDelegate() == null || !(property2.getDelegate() instanceof FirFunctionCall)) {
            return null;
        }
        FirExpression firExpression = property2.getDelegate();
        Intrinsics.checkNotNull(firExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
        FirFunctionCall delegateCall = (FirFunctionCall)firExpression;
        FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default(delegateCall.getCalleeReference(), false, 1, null);
        if (firNamedFunctionSymbol == null) {
            return null;
        }
        FirNamedFunctionSymbol calleeSymbol = firNamedFunctionSymbol;
        if (!Intrinsics.areEqual(calleeSymbol.getCallableId().asSingleFqName().asString(), "kotlin.lazy")) {
            return null;
        }
        FirExpression firExpression2 = CollectionsKt.singleOrNull(delegateCall.getArgumentList().getArguments());
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression2 instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression2 : null;
        if (firAnonymousFunctionExpression == null) {
            return null;
        }
        FirAnonymousFunctionExpression lazyCallArgument = firAnonymousFunctionExpression;
        return lazyCallArgument.getAnonymousFunction();
    }

    private final boolean isEnumEntryInitializer(FirBasedSymbol<?> $this$isEnumEntryInitializer) {
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        FirBasedSymbol<?> firBasedSymbol = $this$isEnumEntryInitializer;
        if (firBasedSymbol instanceof FirConstructorSymbol) {
            if (!((FirConstructorSymbol)$this$isEnumEntryInitializer).isPrimary()) {
                return false;
            }
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)$this$isEnumEntryInitializer);
            ConeClassLikeLookupTagWithFixedSymbol coneClassLikeLookupTagWithFixedSymbol = coneClassLikeLookupTag instanceof ConeClassLikeLookupTagWithFixedSymbol ? (ConeClassLikeLookupTagWithFixedSymbol)coneClassLikeLookupTag : null;
            firClassLikeSymbol = coneClassLikeLookupTagWithFixedSymbol != null ? coneClassLikeLookupTagWithFixedSymbol.getSymbol() : null;
        } else {
            FirBasedSymbol<?> firBasedSymbol2;
            firClassLikeSymbol = firBasedSymbol instanceof FirAnonymousInitializerSymbol ? (FirClassLikeSymbol<?>)((firBasedSymbol2 = ((FirAnonymousInitializerSymbol)$this$isEnumEntryInitializer).getContainingDeclarationSymbol()) instanceof FirClassSymbol ? (FirClassSymbol)firBasedSymbol2 : null) : null;
        }
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> containingClassSymbol = firClassLikeSymbol;
        return FirHelpersKt.getClassKind(containingClassSymbol) == ClassKind.ENUM_ENTRY;
    }

    private static final void check$reportIllegalAccessInEnumEntry(List<FirEnumEntrySymbol> enumEntries, FirEnumEntrySymbol calleeEnumEntry, CheckerContext $context, DiagnosticReporter $reporter, KtSourceElement source, FirEnumEntrySymbol correspondingEnumEntry) {
        FirEnumEntrySymbol precedingEntry = null;
        for (FirEnumEntrySymbol it : enumEntries) {
            if (!Intrinsics.areEqual(it, calleeEnumEntry) && !Intrinsics.areEqual(it, correspondingEnumEntry)) continue;
            precedingEntry = it;
            break;
        }
        if (Intrinsics.areEqual(precedingEntry, correspondingEnumEntry)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), (Object)calleeEnumEntry, null, 16, null);
        }
    }
}

