/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Version {
    public static final String UNKNOWN = "UNKNOWN";
    public static String VERSION;
    public static String RESOURCES_VERSION;
    public static String BUILD_TIME;
    private static String name;
    public static final String NAME;
    public static final String NAME_HTML;

    static {
        try (InputStream is = Version.class.getResourceAsStream("/keycloak-version.properties");){
            Properties props = new Properties();
            props.load(is);
            VERSION = props.getProperty("version");
            BUILD_TIME = props.getProperty("build-time");
            name = props.getProperty("name");
            RESOURCES_VERSION = VERSION.toLowerCase();
            if (RESOURCES_VERSION.endsWith("-snapshot")) {
                RESOURCES_VERSION = RESOURCES_VERSION.replace("-snapshot", "-" + BUILD_TIME.replace(" ", "").replace(":", "").replace("-", ""));
            }
        }
        catch (IOException e) {
            VERSION = UNKNOWN;
            BUILD_TIME = UNKNOWN;
            name = "Keycloak";
        }
        NAME = name;
        NAME_HTML = "<div class=\"kc-logo-text\"><span>" + name + "</span></div>";
    }
}

