/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.time.Duration;
import java.util.Optional;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;

public class AutoOffsetReset {
    protected final AutoOffsetResetStrategy.StrategyType offsetResetStrategy;
    protected final Optional<Duration> duration;

    private AutoOffsetReset(AutoOffsetResetStrategy.StrategyType offsetResetStrategy, Optional<Duration> duration) {
        this.offsetResetStrategy = offsetResetStrategy;
        this.duration = duration;
    }

    protected AutoOffsetReset(AutoOffsetReset autoOffsetReset) {
        this(autoOffsetReset.offsetResetStrategy, autoOffsetReset.duration);
    }

    public static AutoOffsetReset none() {
        return new AutoOffsetReset(AutoOffsetResetStrategy.StrategyType.NONE, Optional.empty());
    }

    public static AutoOffsetReset earliest() {
        return new AutoOffsetReset(AutoOffsetResetStrategy.StrategyType.EARLIEST, Optional.empty());
    }

    public static AutoOffsetReset latest() {
        return new AutoOffsetReset(AutoOffsetResetStrategy.StrategyType.LATEST, Optional.empty());
    }

    public static AutoOffsetReset byDuration(Duration duration) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Duration cannot be negative");
        }
        return new AutoOffsetReset(AutoOffsetResetStrategy.StrategyType.BY_DURATION, Optional.of(duration));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoOffsetReset that = (AutoOffsetReset)o;
        return this.offsetResetStrategy == that.offsetResetStrategy && this.duration.equals(that.duration);
    }

    public int hashCode() {
        int result = this.offsetResetStrategy.hashCode();
        result = 31 * result + this.duration.hashCode();
        return result;
    }
}

