/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Des;
import sun.security.krb5.internal.crypto.EType;

abstract class DesCbcEType
extends EType {
    DesCbcEType() {
    }

    protected abstract byte[] calculateChecksum(byte[] var1, int var2) throws KrbCryptoException;

    @Override
    public int blockSize() {
        return 8;
    }

    @Override
    public int keyType() {
        return 1;
    }

    @Override
    public int keySize() {
        return 8;
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, int n) throws KrbCryptoException {
        byte[] byArray3 = new byte[this.keySize()];
        return this.encrypt(byArray, byArray2, byArray3, n);
    }

    @Override
    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbCryptoException {
        int n2;
        byte[] byArray4;
        if (byArray2.length > 8) {
            throw new KrbCryptoException("Invalid DES Key!");
        }
        int n3 = byArray.length + this.confounderSize() + this.checksumSize();
        if (n3 % this.blockSize() == 0) {
            byArray4 = new byte[n3 + this.blockSize()];
            n2 = 8;
        } else {
            byArray4 = new byte[n3 + this.blockSize() - n3 % this.blockSize()];
            n2 = (byte)(this.blockSize() - n3 % this.blockSize());
        }
        for (int i = n3; i < byArray4.length; ++i) {
            byArray4[i] = n2;
        }
        byte[] byArray5 = Confounder.bytes(this.confounderSize());
        System.arraycopy(byArray5, 0, byArray4, 0, this.confounderSize());
        System.arraycopy(byArray, 0, byArray4, this.startOfData(), byArray.length);
        byte[] byArray6 = this.calculateChecksum(byArray4, byArray4.length);
        System.arraycopy(byArray6, 0, byArray4, this.startOfChecksum(), this.checksumSize());
        byte[] byArray7 = new byte[byArray4.length];
        Des.cbc_encrypt(byArray4, byArray7, byArray2, byArray3, true);
        return byArray7;
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, int n) throws KrbApErrException, KrbCryptoException {
        byte[] byArray3 = new byte[this.keySize()];
        return this.decrypt(byArray, byArray2, byArray3, n);
    }

    @Override
    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) throws KrbApErrException, KrbCryptoException {
        if (byArray2.length > 8) {
            throw new KrbCryptoException("Invalid DES Key!");
        }
        byte[] byArray4 = new byte[byArray.length];
        Des.cbc_encrypt(byArray, byArray4, byArray2, byArray3, false);
        if (!this.isChecksumValid(byArray4)) {
            throw new KrbApErrException(31);
        }
        return byArray4;
    }

    private void copyChecksumField(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < this.checksumSize(); ++i) {
            byArray[this.startOfChecksum() + i] = byArray2[i];
        }
    }

    private byte[] checksumField(byte[] byArray) {
        byte[] byArray2 = new byte[this.checksumSize()];
        for (int i = 0; i < this.checksumSize(); ++i) {
            byArray2[i] = byArray[this.startOfChecksum() + i];
        }
        return byArray2;
    }

    private void resetChecksumField(byte[] byArray) {
        for (int i = this.startOfChecksum(); i < this.startOfChecksum() + this.checksumSize(); ++i) {
            byArray[i] = 0;
        }
    }

    private byte[] generateChecksum(byte[] byArray) throws KrbCryptoException {
        byte[] byArray2 = this.checksumField(byArray);
        this.resetChecksumField(byArray);
        byte[] byArray3 = this.calculateChecksum(byArray, byArray.length);
        this.copyChecksumField(byArray, byArray2);
        return byArray3;
    }

    private boolean isChecksumEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null && byArray2 != null || byArray != null && byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean isChecksumValid(byte[] byArray) throws KrbCryptoException {
        byte[] byArray2 = this.checksumField(byArray);
        byte[] byArray3 = this.generateChecksum(byArray);
        return this.isChecksumEqual(byArray2, byArray3);
    }
}

