/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements the NOT logical operator pixel-wise on an image.


This class is templated over the type of an input image and the type
of the output image. Numeric conversions (castings) are done by the
C++ defaults.

Since the logical NOT operation operates only on boolean types, the
input type must be implicitly convertible to bool, which is only
defined in C++ for integer types, the images passed to this filter
must comply with the requirement of using integer pixel type.

The total operation over one pixel will be


Where "!" is the unary Logical NOT operator in C++.
See:
 itk::simple::Not for the procedural interface

 itk::NotImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkNotImageFilter.h
*/
public class NotImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NotImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NotImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NotImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NotImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NotImageFilter::~NotImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NotImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NotImageFilter::NotImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NotImageFilter() {
    this(SimpleITKJNI.new_NotImageFilter(), true);
  }

  /**
std::string itk::simple::NotImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NotImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NotImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NotImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NotImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NotImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
