/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.text;

import javax.swing.ImageIcon;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.text.SizeMode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ScaledSizeMode
implements SizeMode {
    private static float FACTOR_2D = 2000.0f;

    @Override
    public void init() {
    }

    @Override
    public float getSizeFactor2d(float sizeFactor, NodeModel model) {
        return FACTOR_2D * sizeFactor / model.getCameraDistance();
    }

    @Override
    public float getSizeFactor3d(float sizeFactor, NodeModel model) {
        return sizeFactor * 1.9f + 0.1f;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ScaledSizeMode.class, (String)"ScaledSizeMode.name");
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtilities.loadImageIcon((String)"VisualizationImpl/ScaledSizeMode.png", (boolean)false);
    }

    public String toString() {
        return this.getName();
    }
}

