/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math.util;

import com.jogamp.math.Matrix4f;
import com.jogamp.math.util.SyncAction;
import com.jogamp.math.util.SyncBuffer;
import com.jogamp.math.util.SyncMatrices4f;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public final class SyncMatrices4f16
implements SyncMatrices4f {
    private final Matrix4f[] mats;
    private final float[] f16s;
    private final FloatBuffer fbuf;
    private final SyncAction action = new SyncAction(){

        @Override
        public void sync() {
            int n = 0;
            int n2 = 0;
            while (n2 < SyncMatrices4f16.this.mats.length) {
                SyncMatrices4f16.this.mats[n2].get(SyncMatrices4f16.this.f16s, n);
                ++n2;
                n += 16;
            }
        }
    };

    public SyncMatrices4f16(Matrix4f[] matrix4fArray) {
        this.mats = matrix4fArray;
        this.f16s = new float[16 * matrix4fArray.length];
        this.fbuf = FloatBuffer.wrap(this.f16s);
    }

    @Override
    public SyncAction getAction() {
        return this.action;
    }

    @Override
    public Buffer getBuffer() {
        return this.fbuf;
    }

    @Override
    public SyncBuffer sync() {
        this.getAction().sync();
        return this;
    }

    @Override
    public Buffer getSyncBuffer() {
        this.getAction().sync();
        return this.fbuf;
    }

    @Override
    public Matrix4f[] getMatrices() {
        return this.mats;
    }

    @Override
    public FloatBuffer getSyncFloats() {
        this.getAction().sync();
        return this.fbuf;
    }
}

