/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

public class ChatUsageTotals {
    private final long inputTokenCount;
    private final long outputTokenCount;
    private final boolean visible;
    private final String label;
    private final String inputLabel;
    private final String outputLabel;

    ChatUsageTotals(long inputTokenCount, long outputTokenCount) {
        this(inputTokenCount, outputTokenCount, true, null, null, null);
    }

    private ChatUsageTotals(long inputTokenCount, long outputTokenCount, boolean visible, String label, String inputLabel, String outputLabel) {
        this.inputTokenCount = inputTokenCount;
        this.outputTokenCount = outputTokenCount;
        this.visible = visible;
        this.label = label;
        this.inputLabel = inputLabel;
        this.outputLabel = outputLabel;
    }

    public long getInputTokenCount() {
        return this.inputTokenCount;
    }

    public long getOutputTokenCount() {
        return this.outputTokenCount;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getLabel() {
        return this.label;
    }

    public String formatStatusLine() {
        if (!this.visible) {
            return "";
        }
        String prefix = this.label == null || this.label.trim().isEmpty() ? "" : this.label.trim() + ": ";
        String safeInputLabel = this.inputLabel == null || this.inputLabel.trim().isEmpty() ? "input" : this.inputLabel.trim();
        String safeOutputLabel = this.outputLabel == null || this.outputLabel.trim().isEmpty() ? "output" : this.outputLabel.trim();
        return prefix + safeInputLabel + " " + this.inputTokenCount + ", " + safeOutputLabel + " " + this.outputTokenCount;
    }

    ChatUsageTotals withLabel(String label) {
        if (!this.visible) {
            return this;
        }
        return new ChatUsageTotals(this.inputTokenCount, this.outputTokenCount, true, label, this.inputLabel, this.outputLabel);
    }

    ChatUsageTotals withInputOutputLabels(String inputLabel, String outputLabel) {
        if (!this.visible) {
            return this;
        }
        return new ChatUsageTotals(this.inputTokenCount, this.outputTokenCount, true, this.label, inputLabel, outputLabel);
    }

    static ChatUsageTotals hidden() {
        return new ChatUsageTotals(0L, 0L, false, null, null, null);
    }

    static ChatUsageTotals estimated(long inputTokenCount, long outputTokenCount) {
        return new ChatUsageTotals(inputTokenCount, outputTokenCount, true, null, null, null);
    }
}

