/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import io.github.gitbucket.markedj.Marked;
import io.github.gitbucket.markedj.Options;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;

class ChatMessageRenderer {
    private static final Pattern URL_PATTERN = Pattern.compile("(?i)\\b(?:https?|ftp)://[^\\s\"'<>\\{\\}]+");
    private final Options markdownOptions = this.createMarkdownOptions();

    ChatMessageRenderer() {
    }

    String renderMessage(String text, boolean renderMarkdown) {
        if (renderMarkdown) {
            return this.renderMarkdownMessage(text);
        }
        return this.formatPlainText(text);
    }

    String renderFailureMessage(String text) {
        String normalized = this.normalizeNewlines(text);
        StringBuilder rendered = new StringBuilder();
        Matcher matcher = URL_PATTERN.matcher(normalized);
        int currentIndex = 0;
        while (matcher.find()) {
            this.appendEscapedWithLineBreaks(rendered, normalized.substring(currentIndex, matcher.start()));
            String matched = matcher.group();
            String linkText = this.stripTrailingPunctuation(matched);
            if (linkText.isEmpty()) {
                this.appendEscapedWithLineBreaks(rendered, matched);
            } else {
                String trailing = matched.substring(linkText.length());
                String escapedLink = HtmlUtils.toXMLEscapedText((String)linkText);
                rendered.append("<a href=\"").append(escapedLink).append("\">").append(escapedLink).append("</a>");
                this.appendEscapedWithLineBreaks(rendered, trailing);
            }
            currentIndex = matcher.end();
        }
        this.appendEscapedWithLineBreaks(rendered, normalized.substring(currentIndex));
        return rendered.toString();
    }

    private Options createMarkdownOptions() {
        Options options = new Options();
        options.setSafelist(null);
        return options;
    }

    private String renderMarkdownMessage(String text) {
        try {
            String renderedMarkup = Marked.marked((String)text, (Options)this.markdownOptions);
            if (renderedMarkup == null) {
                return this.formatPlainText(text);
            }
            return renderedMarkup;
        }
        catch (RuntimeException exception) {
            LogUtils.severe((Throwable)exception);
            return this.formatPlainText(text);
        }
    }

    private String formatPlainText(String text) {
        String normalized = this.normalizeNewlines(text);
        String escaped = HtmlUtils.toXMLEscapedText((String)normalized);
        return escaped.replace("\n", "<br>");
    }

    private String normalizeNewlines(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("\r\n", "\n").replace("\r", "\n");
    }

    private void appendEscapedWithLineBreaks(StringBuilder rendered, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        rendered.append(HtmlUtils.toXMLEscapedText((String)text).replace("\n", "<br>"));
    }

    private String stripTrailingPunctuation(String text) {
        int end;
        for (end = text.length(); end > 0 && this.isTrailingPunctuation(text.charAt(end - 1)); --end) {
        }
        return text.substring(0, end);
    }

    private boolean isTrailingPunctuation(char character) {
        return character == '.' || character == ',' || character == ';' || character == ':' || character == '!' || character == '?' || character == ')' || character == ']';
    }
}

