/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridPartition;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableColumn;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class CubridTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn> {
    public SQLTableColumnManager.ColumnModifier<GenericTableColumn> CubridDataTypeModifier = (monitor, column, sql, command) -> {
        String typeName = column.getTypeName();
        DBPDataKind dataKind = column.getDataKind();
        sql.append(' ').append(typeName);
        String modifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)column.getDataSource(), (DBSTypedObject)column, (String)typeName, (DBPDataKind)dataKind);
        if (modifiers != null && !typeName.equalsIgnoreCase("STRING")) {
            sql.append(modifiers);
        } else if (modifiers == null && typeName.equalsIgnoreCase("VARCHAR")) {
            sql.append('(').append(column.getPrecision()).append(')');
        }
    };

    public boolean canCreateObject(@NotNull Object container) {
        if (container instanceof CubridPartition) {
            return false;
        }
        return super.canCreateObject(container);
    }

    @NotNull
    protected CubridTableColumn createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @Nullable Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        CubridTable table = (CubridTable)((Object)container);
        DBSDataType columnType = CubridTableColumnManager.findBestDataType((DBSObject)table, (String[])DBConstants.DEFAULT_DATATYPE_NAMES);
        int columnSize = columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0;
        CubridTableColumn column = new CubridTableColumn((GenericTableBase)table, null, null, false, false, null);
        column.setOrdinalPosition(table.getCachedAttributes().size() + 1);
        column.setName(this.getNewColumnName(monitor, context, table));
        column.setTypeName(columnType == null ? "INTEGER" : columnType.getName());
        column.setMaxLength(columnSize);
        column.setRequired(false);
        column.setDescription(null);
        column.setDefaultValue(null);
        column.setAutoIncrement(false);
        column.setPersisted(false);
        return column;
    }

    @NotNull
    public StringBuilder getNestedDeclaration(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase owner, @NotNull DBECommandAbstract<GenericTableColumn> command, @NotNull Map<String, Object> options) {
        StringBuilder decl = new StringBuilder(40);
        CubridTableColumn column = (CubridTableColumn)command.getObject();
        String columnName = DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)column.getName());
        if (command instanceof SQLObjectEditor.ObjectRenameCommand) {
            columnName = DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)((SQLObjectEditor.ObjectRenameCommand)command).getNewName());
        }
        decl.append(columnName);
        for (SQLTableColumnManager.ColumnModifier modifier : new SQLTableColumnManager.ColumnModifier[]{this.CubridDataTypeModifier, this.NotNullModifier}) {
            modifier.appendModifier(monitor, (DBPObject)column, decl, command);
        }
        if (((DBECommandComposite)command).hasProperty((Object)"required")) {
            decl.append(column.isRequired() ? "" : " NULL");
        }
        if (!CommonUtils.isEmpty((String)column.getDefaultValue()) || ((DBECommandComposite)command).hasProperty((Object)"defaultValue")) {
            decl.append(" DEFAULT ").append(SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDefaultValue())));
        }
        if (column.isAutoIncrement()) {
            decl.append(" AUTO_INCREMENT");
        }
        if (!CommonUtils.isEmpty((String)column.getDescription()) || ((DBECommandComposite)command).hasProperty((Object)"description")) {
            decl.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription())));
        }
        return decl;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        CubridTableColumn column = (CubridTableColumn)command.getObject();
        boolean isView = ((GenericTableBase)column.getTable()).isView();
        String table = ((GenericTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        String columnName = DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)column.getName());
        if (column.isForeignKey() || isView) {
            if (command.hasProperty((Object)"description")) {
                String query = (isView ? "ALTER VIEW " : "ALTER TABLE ") + table + " COMMENT ON COLUMN " + columnName + " = " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()));
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", query));
            }
        } else {
            String query = "ALTER TABLE " + table + " MODIFY " + String.valueOf(this.getNestedDeclaration(monitor, (GenericTableBase)column.getTable(), (DBECommandAbstract<GenericTableColumn>)command, options));
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", query));
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridTableColumn column = (CubridTableColumn)command.getObject();
        CubridDataSource dataSource = (CubridDataSource)column.getDataSource();
        boolean isView = ((GenericTableBase)column.getTable()).isView();
        String table = ((GenericTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", (isView ? "ALTER VIEW " : "ALTER TABLE ") + table + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " AS " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        if (!((CubridDataSource)object.getDataSource()).isShard()) {
            this.processObjectRename(commandContext, (DBSObject)object, options, newName);
        }
    }

    @NotNull
    protected String getNewColumnName(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @NotNull CubridTable parent) throws DBException {
        String name;
        int suffix = 1;
        while (parent.getAttribute(monitor, name = "column" + suffix++) != null) {
        }
        return name;
    }

    public boolean canRenameObject(GenericTableColumn object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }
}

