/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.app.exif;

import bt747.j2se_view.helpers.TaggedFilePathFactory;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;

public class ExifAttribute {
    private int tag;
    private int type;
    private int count;
    private byte[] value;
    private boolean bigEndian;
    private int valueOrgIdx = 0;

    public ExifAttribute() {
    }

    public ExifAttribute(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        this.bigEndian = bl;
        this.tag = n6 = n;
        this.type = n5 = n2;
        this.count = n4 = n3;
        this.newValue(n3 * ExifAttribute.getValueUnitSize(n2));
    }

    private final void newValue(int n) {
        if ((n & 1) != 0) {
            n = (n & 0xFFFE) + 2;
        }
        this.value = new byte[n];
    }

    private static int getValueUnitSize(int n) {
        switch (n) {
            case 1: 
            case 7: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 6: {
                return 1;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 8;
            }
            case 4: 
            case 9: {
                return 4;
            }
            case 5: 
            case 10: {
                return 8;
            }
        }
        return 0;
    }

    public final int getValueIdx() {
        return this.valueOrgIdx;
    }

    private final int size() {
        return ExifAttribute.getValueUnitSize(this.type) * this.count;
    }

    public final int read(byte[] byArray, int n, int n2, boolean bl) {
        this.bigEndian = bl;
        if (n + 12 < byArray.length) {
            int n3;
            this.tag = n3 = TaggedFilePathFactory.getShort2byte(byArray, n, bl);
            this.type = n3 = TaggedFilePathFactory.getShort2byte(byArray, n + 2, bl);
            this.count = n3 = TaggedFilePathFactory.getLong4byte(byArray, n + 4, bl);
            int n4 = n + 8;
            ExifAttribute exifAttribute = this;
            boolean bl2 = false;
            if (exifAttribute.size() > 4 || exifAttribute.type == 13) {
                bl2 = true;
            }
            if (bl2) {
                this.valueOrgIdx = n4 = n2 + TaggedFilePathFactory.getLong4byte(byArray, n + 8, bl);
            }
            n = this.size();
            this.newValue(n);
            for (n2 = 0; n2 < n; ++n2) {
                this.value[n2] = byArray[n4 + n2];
            }
            return 12;
        }
        return 0;
    }

    public final String toString() {
        CharSequence charSequence = "";
        switch (this.type) {
            case 1: {
                charSequence = " Byte:" + this.getIntValue$134621();
                break;
            }
            case 3: {
                charSequence = " Short:" + this.getIntValue$134621();
                break;
            }
            case 4: {
                charSequence = " Long:" + this.getIntValue$134621();
                break;
            }
            case 2: {
                charSequence = new StringBuffer(this.value.length + 10);
                ((StringBuffer)charSequence).append(" ASCII:");
                for (int i = 0; i < this.value.length && this.value[i] != 0; ++i) {
                    ((StringBuffer)charSequence).append((char)this.value[i]);
                }
                charSequence = ((StringBuffer)charSequence).toString();
                break;
            }
            case 7: {
                int n;
                charSequence = new StringBuffer(3 * this.value.length + 40);
                ((StringBuffer)charSequence).append(" UNKNOWN:");
                for (n = 0; n < this.value.length; ++n) {
                    ((StringBuffer)charSequence).append(JavaLibBridge.unsigned2hex(this.value[n], 2));
                }
                ((StringBuffer)charSequence).append("  (");
                for (n = 0; n < this.value.length && this.value[n] != 0; ++n) {
                    ((StringBuffer)charSequence).append((char)this.value[n]);
                }
                ((StringBuffer)charSequence).append(')');
                charSequence = ((StringBuffer)charSequence).toString();
                break;
            }
            case 5: {
                charSequence = " Rat:" + this.getFloatValue(0);
                break;
            }
            case 10: {
                charSequence = " Srat:" + this.getFloatValue(0);
            }
        }
        return "Tag:" + JavaLibBridge.unsigned2hex(this.tag, 4) + " Type:" + JavaLibBridge.unsigned2hex(this.type, 4) + " Count:" + JavaLibBridge.unsigned2hex(this.count, 8) + (String)charSequence;
    }

    public final int getPayloadSize() {
        if (this.value.length <= 4) {
            return 0;
        }
        return this.value.length;
    }

    public int fillBuffer(byte[] byArray, int n, boolean n2, int n3, int n4) {
        int n5;
        TaggedFilePathFactory.addShort2byte(byArray, n, n2 != 0, this.tag);
        TaggedFilePathFactory.addShort2byte(byArray, n + 2, n2 != 0, this.type);
        TaggedFilePathFactory.addLong4byte(byArray, n + 4, n2 != 0, this.count);
        if (this.value.length <= 4) {
            n5 = n + 8;
            n = 0;
        } else {
            n5 = n3;
            TaggedFilePathFactory.addLong4byte(byArray, n + 8, n2 != 0, n3 - n4);
            n = this.value.length;
        }
        for (n2 = 0; n2 < this.value.length; ++n2) {
            byArray[n5 + n2] = this.value[n2];
        }
        return n;
    }

    public final int getTag() {
        return this.tag;
    }

    public final int getType() {
        return this.type;
    }

    public final int getCount() {
        return this.count;
    }

    public final byte[] getValue() {
        return this.value;
    }

    public final float getFloatValue(int n) {
        if (this.type == 5 || this.type == 10) {
            if ((n <<= 3) + 8 <= this.value.length) {
                int n2 = TaggedFilePathFactory.getLong4byte(this.value, n, this.bigEndian);
                if ((n = TaggedFilePathFactory.getLong4byte(this.value, n + 4, this.bigEndian)) == 0) {
                    Generic.debug("Invalid EXIF atribute value");
                    return n2;
                }
                if (n2 < 0 & n < 0 || n2 >= 0 && n > 0) {
                    return (float)n2 / (float)n;
                }
                return -((float)n2) / (float)n;
            }
        } else {
            Generic.debug("Attribute " + this.type + " is not a float");
        }
        return 0.0f;
    }

    public final String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            stringBuffer.append((char)this.value[i]);
        }
        return stringBuffer.toString();
    }

    public final int getIntValue$134621() {
        int n = ExifAttribute.getValueUnitSize(this.type);
        if (n + 0 <= this.value.length) {
            switch (this.type) {
                case 1: {
                    return this.value[0] & 0xFF;
                }
                case 3: {
                    return TaggedFilePathFactory.getShort2byte(this.value, 0, this.bigEndian);
                }
                case 4: {
                    return TaggedFilePathFactory.getLong4byte(this.value, 0, this.bigEndian);
                }
            }
            return 0;
        }
        return 0;
    }

    public final void setIntValue(int n, int n2) {
        int n3 = ExifAttribute.getValueUnitSize(this.type);
        n = n3 * n;
        if (n + n3 <= this.value.length) {
            switch (this.type) {
                case 1: 
                case 7: {
                    this.value[n] = (byte)n2;
                    return;
                }
                case 3: {
                    TaggedFilePathFactory.addShort2byte(this.value, n, this.bigEndian, n2);
                    return;
                }
                case 4: {
                    TaggedFilePathFactory.addLong4byte(this.value, n, this.bigEndian, n2);
                }
            }
        }
    }

    public final void setFloatValue(int n, int n2, int n3) {
        if (this.type == 5 || this.type == 10) {
            if ((n <<= 3) + 8 <= this.value.length) {
                TaggedFilePathFactory.addLong4byte(this.value, n, this.bigEndian, n2);
                TaggedFilePathFactory.addLong4byte(this.value, n + 4, this.bigEndian, n3);
            }
            return;
        }
        Generic.debug("Attribute " + this.type + " is not a float");
    }

    public final float setGpsFloatValue(double d) {
        if (this.type == 5 && this.count == 3) {
            double d2 = d < 0.0 ? -d : d;
            int n = (int)d2;
            d2 -= (double)n;
            this.setFloatValue(0, n, 1);
            n = (int)(d2 *= 60.0);
            d2 -= (double)n;
            this.setFloatValue(1, n, 1);
            n = (int)(d2 * 60.0 * 10000.0);
            this.setFloatValue(2, n, 10000);
        } else {
            Generic.debug("Attribute " + this.type + " is not a float");
        }
        return 0.0f;
    }

    public final void setStringValue(String object) {
        if (this.type == 2) {
            if (((String)object).length() + 1 != this.count) {
                this.count = ((String)object).length() + 1;
                this.newValue(this.count);
            }
            object = ((String)object).toCharArray();
            for (int i = 0; i < ((Object)object).length; ++i) {
                this.value[i] = (byte)object[i];
            }
            this.value[this.count - 1] = 0;
            return;
        }
        Generic.debug("Attribute " + this.type + " is not ASCII");
    }
}

