﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/schemas/SchemasRequest.h>
#include <aws/schemas/Schemas_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace Schemas {
namespace Model {

/**
 */
class ExportSchemaRequest : public SchemasRequest {
 public:
  AWS_SCHEMAS_API ExportSchemaRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ExportSchema"; }

  AWS_SCHEMAS_API Aws::String SerializePayload() const override;

  AWS_SCHEMAS_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the registry.</p>
   */
  inline const Aws::String& GetRegistryName() const { return m_registryName; }
  inline bool RegistryNameHasBeenSet() const { return m_registryNameHasBeenSet; }
  template <typename RegistryNameT = Aws::String>
  void SetRegistryName(RegistryNameT&& value) {
    m_registryNameHasBeenSet = true;
    m_registryName = std::forward<RegistryNameT>(value);
  }
  template <typename RegistryNameT = Aws::String>
  ExportSchemaRequest& WithRegistryName(RegistryNameT&& value) {
    SetRegistryName(std::forward<RegistryNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schema.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  inline bool SchemaNameHasBeenSet() const { return m_schemaNameHasBeenSet; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  ExportSchemaRequest& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifying this limits the results to only this schema version.</p>
   */
  inline const Aws::String& GetSchemaVersion() const { return m_schemaVersion; }
  inline bool SchemaVersionHasBeenSet() const { return m_schemaVersionHasBeenSet; }
  template <typename SchemaVersionT = Aws::String>
  void SetSchemaVersion(SchemaVersionT&& value) {
    m_schemaVersionHasBeenSet = true;
    m_schemaVersion = std::forward<SchemaVersionT>(value);
  }
  template <typename SchemaVersionT = Aws::String>
  ExportSchemaRequest& WithSchemaVersion(SchemaVersionT&& value) {
    SetSchemaVersion(std::forward<SchemaVersionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  ExportSchemaRequest& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_registryName;
  bool m_registryNameHasBeenSet = false;

  Aws::String m_schemaName;
  bool m_schemaNameHasBeenSet = false;

  Aws::String m_schemaVersion;
  bool m_schemaVersionHasBeenSet = false;

  Aws::String m_type;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
