/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Command;

public class GetClassIdCommand
extends Command {
    private String className;
    private int classLoaderId;

    public GetClassIdCommand(String className, int classLoaderId) {
        this();
        this.className = className;
        if (classLoaderId == -1) {
            classLoaderId = 0;
        }
        this.classLoaderId = classLoaderId;
    }

    GetClassIdCommand() {
        super(42);
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return super.toString() + ", className: " + this.className + ", classLoaderId: " + this.classLoaderId;
    }

    void readObject(ObjectInputStream in) throws IOException {
        this.className = in.readUTF();
        this.classLoaderId = in.readInt();
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.className);
        out.writeInt(this.classLoaderId);
    }
}

