/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PoolUtils;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObjectState;
import org.apache.tomcat.dbcp.pool2.UsageTracking;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.BaseGenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObjectInfo;
import org.apache.tomcat.dbcp.pool2.impl.EvictionConfig;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolMXBean;
import org.apache.tomcat.dbcp.pool2.impl.LinkedBlockingDeque;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

public class GenericObjectPool<T>
extends BaseGenericObjectPool<T>
implements ObjectPool<T>,
GenericObjectPoolMXBean,
UsageTracking<T> {
    private volatile String factoryType = null;
    private volatile int maxIdle = 8;
    private volatile int minIdle = 0;
    private final PooledObjectFactory<T> factory;
    private final Map<BaseGenericObjectPool.IdentityWrapper<T>, PooledObject<T>> allObjects = new ConcurrentHashMap<BaseGenericObjectPool.IdentityWrapper<T>, PooledObject<T>>();
    private final AtomicLong createCount = new AtomicLong(0L);
    private long makeObjectCount = 0L;
    private final Object makeObjectCountLock = new Object();
    private final LinkedBlockingDeque<PooledObject<T>> idleObjects;
    private static final String ONAME_BASE = "org.apache.tomcat.dbcp.pool2:type=GenericObjectPool,name=";
    private volatile AbandonedConfig abandonedConfig = null;

    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory) {
        this(pooledObjectFactory, new GenericObjectPoolConfig());
    }

    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig<T> genericObjectPoolConfig) {
        super(genericObjectPoolConfig, ONAME_BASE, genericObjectPoolConfig.getJmxNamePrefix());
        if (pooledObjectFactory == null) {
            this.jmxUnregister();
            throw new IllegalArgumentException("factory may not be null");
        }
        this.factory = pooledObjectFactory;
        this.idleObjects = new LinkedBlockingDeque(genericObjectPoolConfig.getFairness());
        this.setConfig(genericObjectPoolConfig);
    }

    public GenericObjectPool(PooledObjectFactory<T> pooledObjectFactory, GenericObjectPoolConfig<T> genericObjectPoolConfig, AbandonedConfig abandonedConfig) {
        this(pooledObjectFactory, genericObjectPoolConfig);
        this.setAbandonedConfig(abandonedConfig);
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int n) {
        this.maxIdle = n;
    }

    public void setMinIdle(int n) {
        this.minIdle = n;
    }

    @Override
    public int getMinIdle() {
        int n = this.getMaxIdle();
        if (this.minIdle > n) {
            return n;
        }
        return this.minIdle;
    }

    @Override
    public boolean isAbandonedConfig() {
        return this.abandonedConfig != null;
    }

    @Override
    public boolean getLogAbandoned() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null && abandonedConfig.getLogAbandoned();
    }

    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnBorrow();
    }

    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnMaintenance();
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        return abandonedConfig != null ? abandonedConfig.getRemoveAbandonedTimeout() : Integer.MAX_VALUE;
    }

    @Override
    public void setConfig(GenericObjectPoolConfig<T> genericObjectPoolConfig) {
        super.setConfig(genericObjectPoolConfig);
        this.setMaxIdle(genericObjectPoolConfig.getMaxIdle());
        this.setMinIdle(genericObjectPoolConfig.getMinIdle());
        this.setMaxTotal(genericObjectPoolConfig.getMaxTotal());
    }

    public void setAbandonedConfig(AbandonedConfig abandonedConfig) {
        if (abandonedConfig == null) {
            this.abandonedConfig = null;
        } else {
            this.abandonedConfig = new AbandonedConfig();
            this.abandonedConfig.setLogAbandoned(abandonedConfig.getLogAbandoned());
            this.abandonedConfig.setLogWriter(abandonedConfig.getLogWriter());
            this.abandonedConfig.setRemoveAbandonedOnBorrow(abandonedConfig.getRemoveAbandonedOnBorrow());
            this.abandonedConfig.setRemoveAbandonedOnMaintenance(abandonedConfig.getRemoveAbandonedOnMaintenance());
            this.abandonedConfig.setRemoveAbandonedTimeout(abandonedConfig.getRemoveAbandonedTimeout());
            this.abandonedConfig.setUseUsageTracking(abandonedConfig.getUseUsageTracking());
            this.abandonedConfig.setRequireFullStackTrace(abandonedConfig.getRequireFullStackTrace());
        }
    }

    public PooledObjectFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public T borrowObject() throws Exception {
        return this.borrowObject(this.getMaxWaitMillis());
    }

    public T borrowObject(long l) throws Exception {
        this.assertOpen();
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getRemoveAbandonedOnBorrow() && this.getNumIdle() < 2 && this.getNumActive() > this.getMaxTotal() - 3) {
            this.removeAbandoned(abandonedConfig);
        }
        PooledObject<T> pooledObject = null;
        boolean bl = this.getBlockWhenExhausted();
        long l2 = System.currentTimeMillis();
        while (pooledObject == null) {
            Throwable throwable;
            boolean bl2;
            block17: {
                bl2 = false;
                pooledObject = this.idleObjects.pollFirst();
                if (pooledObject == null && (pooledObject = this.create()) != null) {
                    bl2 = true;
                }
                if (bl) {
                    if (pooledObject == null) {
                        pooledObject = l < 0L ? this.idleObjects.takeFirst() : this.idleObjects.pollFirst(l, TimeUnit.MILLISECONDS);
                    }
                    if (pooledObject == null) {
                        throw new NoSuchElementException("Timeout waiting for idle object");
                    }
                } else if (pooledObject == null) {
                    throw new NoSuchElementException("Pool exhausted");
                }
                if (!pooledObject.allocate()) {
                    pooledObject = null;
                }
                if (pooledObject == null) continue;
                try {
                    this.factory.activateObject(pooledObject);
                }
                catch (Exception exception) {
                    try {
                        this.destroy(pooledObject, DestroyMode.NORMAL);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    pooledObject = null;
                    if (!bl2) break block17;
                    throwable = new NoSuchElementException("Unable to activate object");
                    throwable.initCause(exception);
                    throw throwable;
                }
            }
            if (pooledObject == null || !this.getTestOnBorrow()) continue;
            boolean bl3 = false;
            throwable = null;
            try {
                bl3 = this.factory.validateObject(pooledObject);
            }
            catch (Throwable throwable2) {
                PoolUtils.checkRethrow(throwable2);
                throwable = throwable2;
            }
            if (bl3) continue;
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
                this.destroyedByBorrowValidationCount.incrementAndGet();
            }
            catch (Exception exception) {
                // empty catch block
            }
            pooledObject = null;
            if (!bl2) continue;
            NoSuchElementException noSuchElementException = new NoSuchElementException("Unable to validate object");
            noSuchElementException.initCause(throwable);
            throw noSuchElementException;
        }
        this.updateStatsBorrow(pooledObject, System.currentTimeMillis() - l2);
        return pooledObject.getObject();
    }

    @Override
    public void returnObject(T t) {
        PooledObject<T> pooledObject = this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<T>(t));
        if (pooledObject == null) {
            if (!this.isAbandonedConfig()) {
                throw new IllegalStateException("Returned object not currently part of this pool");
            }
            return;
        }
        this.markReturningState(pooledObject);
        long l = pooledObject.getActiveTimeMillis();
        if (this.getTestOnReturn() && !this.factory.validateObject(pooledObject)) {
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            try {
                this.ensureIdle(1, false);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            this.updateStatsReturn(l);
            return;
        }
        try {
            this.factory.passivateObject(pooledObject);
        }
        catch (Exception exception) {
            this.swallowException(exception);
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception2) {
                this.swallowException(exception2);
            }
            try {
                this.ensureIdle(1, false);
            }
            catch (Exception exception3) {
                this.swallowException(exception3);
            }
            this.updateStatsReturn(l);
            return;
        }
        if (!pooledObject.deallocate()) {
            throw new IllegalStateException("Object has already been returned to this pool or is invalid");
        }
        int n = this.getMaxIdle();
        if (this.isClosed() || n > -1 && n <= this.idleObjects.size()) {
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            try {
                this.ensureIdle(1, false);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
        } else {
            if (this.getLifo()) {
                this.idleObjects.addFirst(pooledObject);
            } else {
                this.idleObjects.addLast(pooledObject);
            }
            if (this.isClosed()) {
                this.clear();
            }
        }
        this.updateStatsReturn(l);
    }

    @Override
    public void invalidateObject(T t) throws Exception {
        this.invalidateObject(t, DestroyMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(T t, DestroyMode destroyMode) throws Exception {
        PooledObject<T> pooledObject = this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<T>(t));
        if (pooledObject == null) {
            if (this.isAbandonedConfig()) {
                return;
            }
            throw new IllegalStateException("Invalidated object not currently part of this pool");
        }
        PooledObject<T> pooledObject2 = pooledObject;
        synchronized (pooledObject2) {
            if (pooledObject.getState() != PooledObjectState.INVALID) {
                this.destroy(pooledObject, destroyMode);
            }
        }
        this.ensureIdle(1, false);
    }

    @Override
    public void clear() {
        PooledObject<T> pooledObject = this.idleObjects.poll();
        while (pooledObject != null) {
            try {
                this.destroy(pooledObject, DestroyMode.NORMAL);
            }
            catch (Exception exception) {
                this.swallowException(exception);
            }
            pooledObject = this.idleObjects.poll();
        }
    }

    @Override
    public int getNumActive() {
        return this.allObjects.size() - this.idleObjects.size();
    }

    @Override
    public int getNumIdle() {
        return this.idleObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.stopEvictor();
            this.closed = true;
            this.clear();
            this.jmxUnregister();
            this.idleObjects.interuptTakeWaiters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() throws Exception {
        Object object;
        this.assertOpen();
        if (!this.idleObjects.isEmpty()) {
            object = null;
            EvictionPolicy evictionPolicy = this.getEvictionPolicy();
            Object object2 = this.evictionLock;
            synchronized (object2) {
                EvictionConfig evictionConfig = new EvictionConfig(this.getMinEvictableIdleTimeMillis(), this.getSoftMinEvictableIdleTimeMillis(), this.getMinIdle());
                boolean bl = this.getTestWhileIdle();
                int n = this.getNumTests();
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    if (this.evictionIterator == null || !this.evictionIterator.hasNext()) {
                        this.evictionIterator = new BaseGenericObjectPool.EvictionIterator(this.idleObjects);
                    }
                    if (!this.evictionIterator.hasNext()) {
                        return;
                    }
                    try {
                        object = this.evictionIterator.next();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        --i;
                        this.evictionIterator = null;
                        continue;
                    }
                    if (!object.startEvictionTest()) {
                        --i;
                        continue;
                    }
                    try {
                        bl2 = evictionPolicy.evict(evictionConfig, object, this.idleObjects.size());
                    }
                    catch (Throwable throwable) {
                        PoolUtils.checkRethrow(throwable);
                        this.swallowException(new Exception(throwable));
                        bl2 = false;
                    }
                    if (bl2) {
                        this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                        this.destroyedByEvictorCount.incrementAndGet();
                        continue;
                    }
                    if (bl) {
                        boolean bl3 = false;
                        try {
                            this.factory.activateObject((PooledObject<T>)object);
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                            this.destroyedByEvictorCount.incrementAndGet();
                        }
                        if (bl3) {
                            if (!this.factory.validateObject((PooledObject<T>)object)) {
                                this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                                this.destroyedByEvictorCount.incrementAndGet();
                            } else {
                                try {
                                    this.factory.passivateObject((PooledObject<T>)object);
                                }
                                catch (Exception exception) {
                                    this.destroy((PooledObject<T>)object, DestroyMode.NORMAL);
                                    this.destroyedByEvictorCount.incrementAndGet();
                                }
                            }
                        }
                    }
                    if (object.endEvictionTest(this.idleObjects)) continue;
                }
            }
        }
        if ((object = this.abandonedConfig) != null && ((AbandonedConfig)object).getRemoveAbandonedOnMaintenance()) {
            this.removeAbandoned((AbandonedConfig)object);
        }
    }

    public void preparePool() throws Exception {
        if (this.getMinIdle() < 1) {
            return;
        }
        this.ensureMinIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledObject<T> create() throws Exception {
        PooledObject<T> pooledObject;
        int n = this.getMaxTotal();
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        long l = System.currentTimeMillis();
        long l2 = Math.max(this.getMaxWaitMillis(), 0L);
        Boolean bl = null;
        while (bl == null) {
            pooledObject = this.makeObjectCountLock;
            synchronized (pooledObject) {
                long l3 = this.createCount.incrementAndGet();
                if (l3 > (long)n) {
                    this.createCount.decrementAndGet();
                    if (this.makeObjectCount == 0L) {
                        bl = Boolean.FALSE;
                    } else {
                        this.makeObjectCountLock.wait(l2);
                    }
                } else {
                    ++this.makeObjectCount;
                    bl = Boolean.TRUE;
                }
            }
            if (bl != null || l2 <= 0L || System.currentTimeMillis() - l < l2) continue;
            bl = Boolean.FALSE;
        }
        if (!bl.booleanValue()) {
            return null;
        }
        try {
            pooledObject = this.factory.makeObject();
            if (this.getTestOnCreate() && !this.factory.validateObject(pooledObject)) {
                this.createCount.decrementAndGet();
                PooledObject<T> pooledObject2 = null;
                return pooledObject2;
            }
        }
        catch (Throwable throwable) {
            this.createCount.decrementAndGet();
            throw throwable;
        }
        finally {
            Object object = this.makeObjectCountLock;
            synchronized (object) {
                --this.makeObjectCount;
                this.makeObjectCountLock.notifyAll();
            }
        }
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getLogAbandoned()) {
            pooledObject.setLogAbandoned(true);
            pooledObject.setRequireFullStackTrace(abandonedConfig.getRequireFullStackTrace());
        }
        this.createdCount.incrementAndGet();
        this.allObjects.put(new BaseGenericObjectPool.IdentityWrapper<T>(pooledObject.getObject()), pooledObject);
        return pooledObject;
    }

    private void destroy(PooledObject<T> pooledObject, DestroyMode destroyMode) throws Exception {
        pooledObject.invalidate();
        this.idleObjects.remove(pooledObject);
        this.allObjects.remove(new BaseGenericObjectPool.IdentityWrapper<T>(pooledObject.getObject()));
        try {
            this.factory.destroyObject(pooledObject, destroyMode);
        }
        finally {
            this.destroyedCount.incrementAndGet();
            this.createCount.decrementAndGet();
        }
    }

    @Override
    void ensureMinIdle() throws Exception {
        this.ensureIdle(this.getMinIdle(), true);
    }

    private void ensureIdle(int n, boolean bl) throws Exception {
        PooledObject<T> pooledObject;
        if (n < 1 || this.isClosed() || !bl && !this.idleObjects.hasTakeWaiters()) {
            return;
        }
        while (this.idleObjects.size() < n && (pooledObject = this.create()) != null) {
            if (this.getLifo()) {
                this.idleObjects.addFirst(pooledObject);
                continue;
            }
            this.idleObjects.addLast(pooledObject);
        }
        if (this.isClosed()) {
            this.clear();
        }
    }

    @Override
    public void addObject() throws Exception {
        this.assertOpen();
        if (this.factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        PooledObject<T> pooledObject = this.create();
        this.addIdleObject(pooledObject);
    }

    @Override
    public void addObjects(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.addObject();
        }
    }

    private void addIdleObject(PooledObject<T> pooledObject) throws Exception {
        if (pooledObject != null) {
            this.factory.passivateObject(pooledObject);
            if (this.getLifo()) {
                this.idleObjects.addFirst(pooledObject);
            } else {
                this.idleObjects.addLast(pooledObject);
            }
        }
    }

    private int getNumTests() {
        int n = this.getNumTestsPerEvictionRun();
        if (n >= 0) {
            return Math.min(n, this.idleObjects.size());
        }
        return (int)Math.ceil((double)this.idleObjects.size() / Math.abs((double)n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAbandoned(AbandonedConfig abandonedConfig) {
        long l = System.currentTimeMillis();
        long l2 = l - (long)abandonedConfig.getRemoveAbandonedTimeout() * 1000L;
        ArrayList<PooledObject<T>> arrayList = new ArrayList<PooledObject<T>>();
        Iterator<PooledObject<Object>> iterator = this.allObjects.values().iterator();
        while (iterator.hasNext()) {
            PooledObject<T> pooledObject;
            PooledObject<T> pooledObject2 = pooledObject = iterator.next();
            synchronized (pooledObject2) {
                if (pooledObject.getState() == PooledObjectState.ALLOCATED && pooledObject.getLastUsedTime() <= l2) {
                    pooledObject.markAbandoned();
                    arrayList.add(pooledObject);
                }
            }
        }
        for (PooledObject<Object> pooledObject : arrayList) {
            if (abandonedConfig.getLogAbandoned()) {
                pooledObject.printStackTrace(abandonedConfig.getLogWriter());
            }
            try {
                this.invalidateObject(pooledObject.getObject(), DestroyMode.ABANDONED);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void use(T t) {
        AbandonedConfig abandonedConfig = this.abandonedConfig;
        if (abandonedConfig != null && abandonedConfig.getUseUsageTracking()) {
            PooledObject<T> pooledObject = this.allObjects.get(new BaseGenericObjectPool.IdentityWrapper<T>(t));
            pooledObject.use();
        }
    }

    @Override
    public int getNumWaiters() {
        if (this.getBlockWhenExhausted()) {
            return this.idleObjects.getTakeQueueLength();
        }
        return 0;
    }

    @Override
    public String getFactoryType() {
        if (this.factoryType == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.factory.getClass().getName());
            stringBuilder.append('<');
            Class<?> clazz = PoolImplUtils.getFactoryType(this.factory.getClass());
            stringBuilder.append(clazz.getName());
            stringBuilder.append('>');
            this.factoryType = stringBuilder.toString();
        }
        return this.factoryType;
    }

    @Override
    public Set<DefaultPooledObjectInfo> listAllObjects() {
        HashSet<DefaultPooledObjectInfo> hashSet = new HashSet<DefaultPooledObjectInfo>(this.allObjects.size());
        for (PooledObject<T> pooledObject : this.allObjects.values()) {
            hashSet.add(new DefaultPooledObjectInfo(pooledObject));
        }
        return hashSet;
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        super.toStringAppendFields(stringBuilder);
        stringBuilder.append(", factoryType=");
        stringBuilder.append(this.factoryType);
        stringBuilder.append(", maxIdle=");
        stringBuilder.append(this.maxIdle);
        stringBuilder.append(", minIdle=");
        stringBuilder.append(this.minIdle);
        stringBuilder.append(", factory=");
        stringBuilder.append(this.factory);
        stringBuilder.append(", allObjects=");
        stringBuilder.append(this.allObjects);
        stringBuilder.append(", createCount=");
        stringBuilder.append(this.createCount);
        stringBuilder.append(", idleObjects=");
        stringBuilder.append(this.idleObjects);
        stringBuilder.append(", abandonedConfig=");
        stringBuilder.append(this.abandonedConfig);
    }
}

