/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Region;
import com.tigervnc.rfb.ServerParams;

public class CopyRectDecoder
extends Decoder {
    public CopyRectDecoder() {
        super(Decoder.DecoderFlags.DecoderPlain);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ServerParams serverParams, OutStream outStream) {
        outStream.copyBytes(inStream, 4);
    }

    @Override
    public void getAffectedRegion(Rect rect, Object object, int n, ServerParams serverParams, Region region) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        int n2 = memInStream.readU16();
        int n3 = memInStream.readU16();
        super.getAffectedRegion(rect, object, n, serverParams, region);
        region.assign_union(new Region(rect.translate(new Point(n2 - rect.tl.x, n3 - rect.tl.y))));
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ServerParams serverParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        int n2 = memInStream.readU16();
        int n3 = memInStream.readU16();
        modifiablePixelBuffer.copyRect(rect, new Point(rect.tl.x - n2, rect.tl.y - n3));
    }
}

