\name{BinaryClosingByReconstructionImageFilter}
\alias{BinaryClosingByReconstructionImageFilter}
\title{BinaryClosingByReconstructionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
binary closing by reconstruction of an image.
BinaryClosingByReconstructionImageFilter}
\details{
This filter removes small (i.e., smaller than the structuring element)
holes in the image. It is defined as: Closing(f) =
ReconstructionByErosion(Dilation(f)).
The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
MorphologyImageFilter , ClosingByReconstructionImageFilter , BinaryOpeningByReconstructionImageFilter
BinaryClosingByReconstruction for the procedural interface
itk::BinaryClosingByReconstructionImageFilter for the Doxygen on the original ITK class.
BinaryClosingByReconstructionImageFilter}
%C++ includes: sitkBinaryClosingByReconstructionImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryClosingByReconstructionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetForegroundValue() const:}{
Get the value in the image considered as "foreground". Defaults to
maximum value of InputPixelType.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value in the image to consider as "foreground". Defaults to
maximum value of InputPixelType.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryClosingByReconstructionImageFilter():}{
Destructor
}
}
}
