from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

SLOVAK_LANG_MODEL = {
    36: {  # 'A'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.LIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.LIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    46: {  # 'B'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    50: {  # 'C'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.LIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    43: {  # 'D'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.LIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    49: {  # 'E'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.LIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.LIKELY,  # 'T'
        60: SequenceLikelihood.LIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.LIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    59: {  # 'F'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    62: {  # 'G'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    55: {  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    52: {  # 'I'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.LIKELY,  # 'C'
        43: SequenceLikelihood.LIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.LIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    57: {  # 'J'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    42: {  # 'K'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    54: {  # 'L'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    40: {  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.LIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    39: {  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    44: {  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.LIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    33: {  # 'P'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    75: {  # 'Q'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    45: {  # 'R'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    35: {  # 'S'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.LIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.LIKELY,  # 'K'
        54: SequenceLikelihood.LIKELY,  # 'L'
        40: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.LIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.LIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    41: {  # 'T'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.LIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    60: {  # 'U'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        35: SequenceLikelihood.LIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    37: {  # 'V'
        36: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.LIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.LIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.LIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.LIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.LIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    65: {  # 'W'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    70: {  # 'X'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    67: {  # 'Y'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    53: {  # 'Z'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    2: {  # 'a'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.LIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.POSITIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.POSITIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    22: {  # 'b'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.LIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.LIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.LIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    16: {  # 'c'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.LIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    12: {  # 'd'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.POSITIVE,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.LIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.POSITIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    3: {  # 'e'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        32: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.POSITIVE,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.POSITIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.POSITIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.POSITIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.POSITIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    34: {  # 'f'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    32: {  # 'g'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    17: {  # 'h'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.LIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.POSITIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    5: {  # 'i'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.POSITIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    19: {  # 'j'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    10: {  # 'k'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.POSITIVE,  # 'é'
        23: SequenceLikelihood.LIKELY,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.LIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.LIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    11: {  # 'l'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.POSITIVE,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.POSITIVE,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    13: {  # 'm'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.LIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.POSITIVE,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.LIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.UNLIKELY,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    4: {  # 'n'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        32: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.POSITIVE,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    1: {  # 'o'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.POSITIVE,  # 'f'
        32: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.LIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.POSITIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    14: {  # 'p'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.LIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.POSITIVE,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.LIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.LIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    76: {  # 'q'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    6: {  # 'r'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.POSITIVE,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.POSITIVE,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.POSITIVE,  # 'ó'
        38: SequenceLikelihood.LIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    9: {  # 's'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.LIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.LIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.POSITIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    7: {  # 't'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.LIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.POSITIVE,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.POSITIVE,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    15: {  # 'u'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.LIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.LIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.LIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.LIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    8: {  # 'v'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.UNLIKELY,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.POSITIVE,  # 'ä'
        27: SequenceLikelihood.POSITIVE,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.LIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.POSITIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.LIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    61: {  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.LIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    56: {  # 'x'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    21: {  # 'y'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.POSITIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    20: {  # 'z'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.POSITIVE,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.POSITIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.LIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.LIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.LIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.LIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    71: {  # 'Á'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    84: {  # 'Ä'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.NEGATIVE,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    78: {  # 'É'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    77: {  # 'Í'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    81: {  # 'Ó'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    83: {  # 'Ô'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    66: {  # 'Ú'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    79: {  # 'Ý'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    18: {  # 'á'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.LIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    58: {  # 'ä'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.NEGATIVE,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.NEGATIVE,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.LIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    27: {  # 'é'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    23: {  # 'í'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.LIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.LIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    48: {  # 'ó'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.LIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.UNLIKELY,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    38: {  # 'ô'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.NEGATIVE,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.POSITIVE,  # 'ž'
    },
    29: {  # 'ú'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.UNLIKELY,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.POSITIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.POSITIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    24: {  # 'ý'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.LIKELY,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.POSITIVE,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    63: {  # 'Č'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.LIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    25: {  # 'č'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.POSITIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    74: {  # 'Ď'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.NEGATIVE,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.NEGATIVE,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    51: {  # 'ď'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.LIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    85: {  # 'Ĺ'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.NEGATIVE,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    69: {  # 'ĺ'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.NEGATIVE,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.NEGATIVE,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.NEGATIVE,  # 'S'
        41: SequenceLikelihood.NEGATIVE,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.LIKELY,  # 'ž'
    },
    73: {  # 'Ľ'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.UNLIKELY,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    31: {  # 'ľ'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.NEGATIVE,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.LIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.LIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    82: {  # 'Ň'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.NEGATIVE,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.NEGATIVE,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    47: {  # 'ň'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    86: {  # 'Ŕ'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.NEGATIVE,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.NEGATIVE,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.NEGATIVE,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.NEGATIVE,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.NEGATIVE,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.NEGATIVE,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        1: SequenceLikelihood.NEGATIVE,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.NEGATIVE,  # 'u'
        8: SequenceLikelihood.NEGATIVE,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.NEGATIVE,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    72: {  # 'ŕ'
        36: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.NEGATIVE,  # 'D'
        49: SequenceLikelihood.NEGATIVE,  # 'E'
        59: SequenceLikelihood.NEGATIVE,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.NEGATIVE,  # 'H'
        52: SequenceLikelihood.NEGATIVE,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.NEGATIVE,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        44: SequenceLikelihood.NEGATIVE,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        35: SequenceLikelihood.NEGATIVE,  # 'S'
        41: SequenceLikelihood.NEGATIVE,  # 'T'
        60: SequenceLikelihood.NEGATIVE,  # 'U'
        37: SequenceLikelihood.NEGATIVE,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    64: {  # 'Š'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.LIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.UNLIKELY,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    28: {  # 'š'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.POSITIVE,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.POSITIVE,  # 'p'
        76: SequenceLikelihood.UNLIKELY,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        15: SequenceLikelihood.LIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.UNLIKELY,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.LIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.LIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    80: {  # 'Ť'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.NEGATIVE,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.NEGATIVE,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.NEGATIVE,  # 'b'
        16: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.NEGATIVE,  # 'g'
        17: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.NEGATIVE,  # 'l'
        13: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.NEGATIVE,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.NEGATIVE,  # 'v'
        61: SequenceLikelihood.NEGATIVE,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.NEGATIVE,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.NEGATIVE,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.NEGATIVE,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.NEGATIVE,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.NEGATIVE,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    30: {  # 'ť'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.UNLIKELY,  # 'W'
        70: SequenceLikelihood.UNLIKELY,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.UNLIKELY,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.NEGATIVE,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.UNLIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    68: {  # 'Ž'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.UNLIKELY,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.NEGATIVE,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        3: SequenceLikelihood.LIKELY,  # 'e'
        34: SequenceLikelihood.NEGATIVE,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.UNLIKELY,  # 'k'
        11: SequenceLikelihood.UNLIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        1: SequenceLikelihood.UNLIKELY,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        15: SequenceLikelihood.UNLIKELY,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.NEGATIVE,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        71: SequenceLikelihood.UNLIKELY,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.UNLIKELY,  # 'É'
        77: SequenceLikelihood.UNLIKELY,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.NEGATIVE,  # 'é'
        23: SequenceLikelihood.UNLIKELY,  # 'í'
        48: SequenceLikelihood.NEGATIVE,  # 'ó'
        38: SequenceLikelihood.NEGATIVE,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.NEGATIVE,  # 'ý'
        63: SequenceLikelihood.NEGATIVE,  # 'Č'
        25: SequenceLikelihood.NEGATIVE,  # 'č'
        74: SequenceLikelihood.UNLIKELY,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.UNLIKELY,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.UNLIKELY,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.UNLIKELY,  # 'Ň'
        47: SequenceLikelihood.UNLIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.NEGATIVE,  # 'ŕ'
        64: SequenceLikelihood.UNLIKELY,  # 'Š'
        28: SequenceLikelihood.NEGATIVE,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.NEGATIVE,  # 'ť'
        68: SequenceLikelihood.NEGATIVE,  # 'Ž'
        26: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    26: {  # 'ž'
        36: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        50: SequenceLikelihood.UNLIKELY,  # 'C'
        43: SequenceLikelihood.UNLIKELY,  # 'D'
        49: SequenceLikelihood.UNLIKELY,  # 'E'
        59: SequenceLikelihood.UNLIKELY,  # 'F'
        62: SequenceLikelihood.NEGATIVE,  # 'G'
        55: SequenceLikelihood.UNLIKELY,  # 'H'
        52: SequenceLikelihood.UNLIKELY,  # 'I'
        57: SequenceLikelihood.UNLIKELY,  # 'J'
        42: SequenceLikelihood.UNLIKELY,  # 'K'
        54: SequenceLikelihood.UNLIKELY,  # 'L'
        40: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        44: SequenceLikelihood.UNLIKELY,  # 'O'
        33: SequenceLikelihood.UNLIKELY,  # 'P'
        75: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        35: SequenceLikelihood.UNLIKELY,  # 'S'
        41: SequenceLikelihood.UNLIKELY,  # 'T'
        60: SequenceLikelihood.UNLIKELY,  # 'U'
        37: SequenceLikelihood.UNLIKELY,  # 'V'
        65: SequenceLikelihood.NEGATIVE,  # 'W'
        70: SequenceLikelihood.NEGATIVE,  # 'X'
        67: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        22: SequenceLikelihood.LIKELY,  # 'b'
        16: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        3: SequenceLikelihood.POSITIVE,  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'f'
        32: SequenceLikelihood.UNLIKELY,  # 'g'
        17: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        10: SequenceLikelihood.POSITIVE,  # 'k'
        11: SequenceLikelihood.LIKELY,  # 'l'
        13: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        1: SequenceLikelihood.POSITIVE,  # 'o'
        14: SequenceLikelihood.UNLIKELY,  # 'p'
        76: SequenceLikelihood.NEGATIVE,  # 'q'
        6: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        15: SequenceLikelihood.POSITIVE,  # 'u'
        8: SequenceLikelihood.UNLIKELY,  # 'v'
        61: SequenceLikelihood.UNLIKELY,  # 'w'
        56: SequenceLikelihood.UNLIKELY,  # 'x'
        21: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        71: SequenceLikelihood.NEGATIVE,  # 'Á'
        84: SequenceLikelihood.NEGATIVE,  # 'Ä'
        78: SequenceLikelihood.NEGATIVE,  # 'É'
        77: SequenceLikelihood.NEGATIVE,  # 'Í'
        81: SequenceLikelihood.NEGATIVE,  # 'Ó'
        83: SequenceLikelihood.NEGATIVE,  # 'Ô'
        66: SequenceLikelihood.UNLIKELY,  # 'Ú'
        79: SequenceLikelihood.NEGATIVE,  # 'Ý'
        18: SequenceLikelihood.UNLIKELY,  # 'á'
        58: SequenceLikelihood.NEGATIVE,  # 'ä'
        27: SequenceLikelihood.UNLIKELY,  # 'é'
        23: SequenceLikelihood.POSITIVE,  # 'í'
        48: SequenceLikelihood.UNLIKELY,  # 'ó'
        38: SequenceLikelihood.UNLIKELY,  # 'ô'
        29: SequenceLikelihood.UNLIKELY,  # 'ú'
        24: SequenceLikelihood.UNLIKELY,  # 'ý'
        63: SequenceLikelihood.UNLIKELY,  # 'Č'
        25: SequenceLikelihood.UNLIKELY,  # 'č'
        74: SequenceLikelihood.NEGATIVE,  # 'Ď'
        51: SequenceLikelihood.UNLIKELY,  # 'ď'
        85: SequenceLikelihood.NEGATIVE,  # 'Ĺ'
        69: SequenceLikelihood.UNLIKELY,  # 'ĺ'
        73: SequenceLikelihood.NEGATIVE,  # 'Ľ'
        31: SequenceLikelihood.UNLIKELY,  # 'ľ'
        82: SequenceLikelihood.NEGATIVE,  # 'Ň'
        47: SequenceLikelihood.LIKELY,  # 'ň'
        86: SequenceLikelihood.NEGATIVE,  # 'Ŕ'
        72: SequenceLikelihood.UNLIKELY,  # 'ŕ'
        64: SequenceLikelihood.NEGATIVE,  # 'Š'
        28: SequenceLikelihood.LIKELY,  # 'š'
        80: SequenceLikelihood.NEGATIVE,  # 'Ť'
        30: SequenceLikelihood.UNLIKELY,  # 'ť'
        68: SequenceLikelihood.UNLIKELY,  # 'Ž'
        26: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
}

# Character Mapping Table(s):
CP852_SLOVAK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 46,  # 'B'
    67: 50,  # 'C'
    68: 43,  # 'D'
    69: 49,  # 'E'
    70: 59,  # 'F'
    71: 62,  # 'G'
    72: 55,  # 'H'
    73: 52,  # 'I'
    74: 57,  # 'J'
    75: 42,  # 'K'
    76: 54,  # 'L'
    77: 40,  # 'M'
    78: 39,  # 'N'
    79: 44,  # 'O'
    80: 33,  # 'P'
    81: 75,  # 'Q'
    82: 45,  # 'R'
    83: 35,  # 'S'
    84: 41,  # 'T'
    85: 60,  # 'U'
    86: 37,  # 'V'
    87: 65,  # 'W'
    88: 70,  # 'X'
    89: 67,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 22,  # 'b'
    99: 16,  # 'c'
    100: 12,  # 'd'
    101: 3,  # 'e'
    102: 34,  # 'f'
    103: 32,  # 'g'
    104: 17,  # 'h'
    105: 5,  # 'i'
    106: 19,  # 'j'
    107: 10,  # 'k'
    108: 11,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 14,  # 'p'
    113: 76,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 15,  # 'u'
    118: 8,  # 'v'
    119: 61,  # 'w'
    120: 56,  # 'x'
    121: 21,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 27,  # 'é'
    131: 0,  # 'â'
    132: 58,  # 'ä'
    133: 0,  # 'ů'
    134: 0,  # 'ć'
    135: 0,  # 'ç'
    136: 0,  # 'ł'
    137: 0,  # 'ë'
    138: 0,  # 'Ő'
    139: 0,  # 'ő'
    140: 0,  # 'î'
    141: 0,  # 'Ź'
    142: 84,  # 'Ä'
    143: 0,  # 'Ć'
    144: 78,  # 'É'
    145: 85,  # 'Ĺ'
    146: 69,  # 'ĺ'
    147: 38,  # 'ô'
    148: 0,  # 'ö'
    149: 73,  # 'Ľ'
    150: 31,  # 'ľ'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 80,  # 'Ť'
    156: 30,  # 'ť'
    157: 0,  # 'Ł'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 25,  # 'č'
    160: 18,  # 'á'
    161: 23,  # 'í'
    162: 48,  # 'ó'
    163: 29,  # 'ú'
    164: 0,  # 'Ą'
    165: 0,  # 'ą'
    166: 68,  # 'Ž'
    167: 26,  # 'ž'
    168: 0,  # 'Ę'
    169: 0,  # 'ę'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: 0,  # 'ź'
    172: 63,  # 'Č'
    173: 0,  # 'ş'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 71,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'Ě'
    184: 0,  # 'Ş'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Ż'
    190: 0,  # 'ż'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ă'
    199: 0,  # 'ă'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'đ'
    209: 0,  # 'Đ'
    210: 74,  # 'Ď'
    211: 0,  # 'Ë'
    212: 51,  # 'ď'
    213: 82,  # 'Ň'
    214: 77,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'ě'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 0,  # 'Ţ'
    222: 0,  # 'Ů'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 81,  # 'Ó'
    225: 0,  # 'ß'
    226: 83,  # 'Ô'
    227: 0,  # 'Ń'
    228: 0,  # 'ń'
    229: 47,  # 'ň'
    230: 64,  # 'Š'
    231: 28,  # 'š'
    232: 86,  # 'Ŕ'
    233: 66,  # 'Ú'
    234: 72,  # 'ŕ'
    235: 0,  # 'Ű'
    236: 24,  # 'ý'
    237: 79,  # 'Ý'
    238: 0,  # 'ţ'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '˝'
    242: CharacterCategory.SYMBOL,  # '˛'
    243: 0,  # 'ˇ'
    244: CharacterCategory.SYMBOL,  # '˘'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: 0,  # 'ű'
    252: 0,  # 'Ř'
    253: 0,  # 'ř'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP852_SLOVAK_MODEL = SingleByteCharSetModel(
    charset_name="CP852",
    language="Slovak",
    char_to_order_map=CP852_SLOVAK_CHAR_TO_ORDER,
    language_model=SLOVAK_LANG_MODEL,
    typical_positive_ratio=0.935065537950628,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÄÉÍÓÔÚÝáäéíóôúýČčĎďĹĺĽľŇňŔŕŠšŤťŽž",
)

ISO_8859_2_SLOVAK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 46,  # 'B'
    67: 50,  # 'C'
    68: 43,  # 'D'
    69: 49,  # 'E'
    70: 59,  # 'F'
    71: 62,  # 'G'
    72: 55,  # 'H'
    73: 52,  # 'I'
    74: 57,  # 'J'
    75: 42,  # 'K'
    76: 54,  # 'L'
    77: 40,  # 'M'
    78: 39,  # 'N'
    79: 44,  # 'O'
    80: 33,  # 'P'
    81: 75,  # 'Q'
    82: 45,  # 'R'
    83: 35,  # 'S'
    84: 41,  # 'T'
    85: 60,  # 'U'
    86: 37,  # 'V'
    87: 65,  # 'W'
    88: 70,  # 'X'
    89: 67,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 22,  # 'b'
    99: 16,  # 'c'
    100: 12,  # 'd'
    101: 3,  # 'e'
    102: 34,  # 'f'
    103: 32,  # 'g'
    104: 17,  # 'h'
    105: 5,  # 'i'
    106: 19,  # 'j'
    107: 10,  # 'k'
    108: 11,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 14,  # 'p'
    113: 76,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 15,  # 'u'
    118: 8,  # 'v'
    119: 61,  # 'w'
    120: 56,  # 'x'
    121: 21,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 73,  # 'Ľ'
    166: 0,  # 'Ś'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 64,  # 'Š'
    170: 0,  # 'Ş'
    171: 80,  # 'Ť'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 68,  # 'Ž'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 31,  # 'ľ'
    182: 0,  # 'ś'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 28,  # 'š'
    186: 0,  # 'ş'
    187: 30,  # 'ť'
    188: 0,  # 'ź'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 26,  # 'ž'
    191: 0,  # 'ż'
    192: 86,  # 'Ŕ'
    193: 71,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 84,  # 'Ä'
    197: 85,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 63,  # 'Č'
    201: 78,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 77,  # 'Í'
    206: 0,  # 'Î'
    207: 74,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 82,  # 'Ň'
    211: 81,  # 'Ó'
    212: 83,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 66,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 79,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 72,  # 'ŕ'
    225: 18,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 58,  # 'ä'
    229: 69,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 25,  # 'č'
    233: 27,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 23,  # 'í'
    238: 0,  # 'î'
    239: 51,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 47,  # 'ň'
    243: 48,  # 'ó'
    244: 38,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 29,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 24,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_2_SLOVAK_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-2",
    language="Slovak",
    char_to_order_map=ISO_8859_2_SLOVAK_CHAR_TO_ORDER,
    language_model=SLOVAK_LANG_MODEL,
    typical_positive_ratio=0.935065537950628,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÄÉÍÓÔÚÝáäéíóôúýČčĎďĹĺĽľŇňŔŕŠšŤťŽž",
)

ISO_8859_16_SLOVAK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 46,  # 'B'
    67: 50,  # 'C'
    68: 43,  # 'D'
    69: 49,  # 'E'
    70: 59,  # 'F'
    71: 62,  # 'G'
    72: 55,  # 'H'
    73: 52,  # 'I'
    74: 57,  # 'J'
    75: 42,  # 'K'
    76: 54,  # 'L'
    77: 40,  # 'M'
    78: 39,  # 'N'
    79: 44,  # 'O'
    80: 33,  # 'P'
    81: 75,  # 'Q'
    82: 45,  # 'R'
    83: 35,  # 'S'
    84: 41,  # 'T'
    85: 60,  # 'U'
    86: 37,  # 'V'
    87: 65,  # 'W'
    88: 70,  # 'X'
    89: 67,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 22,  # 'b'
    99: 16,  # 'c'
    100: 12,  # 'd'
    101: 3,  # 'e'
    102: 34,  # 'f'
    103: 32,  # 'g'
    104: 17,  # 'h'
    105: 5,  # 'i'
    106: 19,  # 'j'
    107: 10,  # 'k'
    108: 11,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 14,  # 'p'
    113: 76,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 15,  # 'u'
    118: 8,  # 'v'
    119: 61,  # 'w'
    120: 56,  # 'x'
    121: 21,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ą'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '„'
    166: 64,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 28,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ș'
    171: CharacterCategory.SYMBOL,  # '«'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'ź'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 63,  # 'Č'
    179: 0,  # 'ł'
    180: 68,  # 'Ž'
    181: CharacterCategory.SYMBOL,  # '”'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 26,  # 'ž'
    185: 25,  # 'č'
    186: 0,  # 'ș'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 71,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 84,  # 'Ä'
    197: 0,  # 'Ć'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 78,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 77,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ò'
    211: 81,  # 'Ó'
    212: 83,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: 0,  # 'Ś'
    216: 0,  # 'Ű'
    217: 0,  # 'Ù'
    218: 66,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ę'
    222: 0,  # 'Ț'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 18,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 58,  # 'ä'
    229: 0,  # 'ć'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 27,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 23,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ò'
    243: 48,  # 'ó'
    244: 38,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: 0,  # 'ś'
    248: 0,  # 'ű'
    249: 0,  # 'ù'
    250: 29,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ę'
    254: 0,  # 'ț'
    255: 0,  # 'ÿ'
}

ISO_8859_16_SLOVAK_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-16",
    language="Slovak",
    char_to_order_map=ISO_8859_16_SLOVAK_CHAR_TO_ORDER,
    language_model=SLOVAK_LANG_MODEL,
    typical_positive_ratio=0.9391284220762837,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÄÉÍÓÔÚÝáäéíóôúýČčĎďĹĺĽľŇňŔŕŠšŤťŽž",
)

MACLATIN2_SLOVAK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 46,  # 'B'
    67: 50,  # 'C'
    68: 43,  # 'D'
    69: 49,  # 'E'
    70: 59,  # 'F'
    71: 62,  # 'G'
    72: 55,  # 'H'
    73: 52,  # 'I'
    74: 57,  # 'J'
    75: 42,  # 'K'
    76: 54,  # 'L'
    77: 40,  # 'M'
    78: 39,  # 'N'
    79: 44,  # 'O'
    80: 33,  # 'P'
    81: 75,  # 'Q'
    82: 45,  # 'R'
    83: 35,  # 'S'
    84: 41,  # 'T'
    85: 60,  # 'U'
    86: 37,  # 'V'
    87: 65,  # 'W'
    88: 70,  # 'X'
    89: 67,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 22,  # 'b'
    99: 16,  # 'c'
    100: 12,  # 'd'
    101: 3,  # 'e'
    102: 34,  # 'f'
    103: 32,  # 'g'
    104: 17,  # 'h'
    105: 5,  # 'i'
    106: 19,  # 'j'
    107: 10,  # 'k'
    108: 11,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 14,  # 'p'
    113: 76,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 15,  # 'u'
    118: 8,  # 'v'
    119: 61,  # 'w'
    120: 56,  # 'x'
    121: 21,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 84,  # 'Ä'
    129: 0,  # 'Ā'
    130: 0,  # 'ā'
    131: 78,  # 'É'
    132: 0,  # 'Ą'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 18,  # 'á'
    136: 0,  # 'ą'
    137: 63,  # 'Č'
    138: 58,  # 'ä'
    139: 25,  # 'č'
    140: 0,  # 'Ć'
    141: 0,  # 'ć'
    142: 27,  # 'é'
    143: 0,  # 'Ź'
    144: 0,  # 'ź'
    145: 74,  # 'Ď'
    146: 23,  # 'í'
    147: 51,  # 'ď'
    148: 0,  # 'Ē'
    149: 0,  # 'ē'
    150: 0,  # 'Ė'
    151: 48,  # 'ó'
    152: 0,  # 'ė'
    153: 38,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 29,  # 'ú'
    157: 0,  # 'Ě'
    158: 0,  # 'ě'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ę'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'ę'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'ģ'
    175: 0,  # 'Į'
    176: 0,  # 'į'
    177: 0,  # 'Ī'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'ī'
    181: 0,  # 'Ķ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: 0,  # 'ł'
    185: 0,  # 'Ļ'
    186: 0,  # 'ļ'
    187: 73,  # 'Ľ'
    188: 31,  # 'ľ'
    189: 85,  # 'Ĺ'
    190: 69,  # 'ĺ'
    191: 0,  # 'Ņ'
    192: 0,  # 'ņ'
    193: 0,  # 'Ń'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ń'
    197: 82,  # 'Ň'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 47,  # 'ň'
    204: 0,  # 'Ő'
    205: 0,  # 'Õ'
    206: 0,  # 'ő'
    207: 0,  # 'Ō'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ō'
    217: 86,  # 'Ŕ'
    218: 72,  # 'ŕ'
    219: 0,  # 'Ř'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ř'
    223: 0,  # 'Ŗ'
    224: 0,  # 'ŗ'
    225: 64,  # 'Š'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: 28,  # 'š'
    229: 0,  # 'Ś'
    230: 0,  # 'ś'
    231: 71,  # 'Á'
    232: 80,  # 'Ť'
    233: 30,  # 'ť'
    234: 77,  # 'Í'
    235: 68,  # 'Ž'
    236: 26,  # 'ž'
    237: 0,  # 'Ū'
    238: 81,  # 'Ó'
    239: 83,  # 'Ô'
    240: 0,  # 'ū'
    241: 0,  # 'Ů'
    242: 66,  # 'Ú'
    243: 0,  # 'ů'
    244: 0,  # 'Ű'
    245: 0,  # 'ű'
    246: 0,  # 'Ų'
    247: 0,  # 'ų'
    248: 79,  # 'Ý'
    249: 24,  # 'ý'
    250: 0,  # 'ķ'
    251: 0,  # 'Ż'
    252: 0,  # 'Ł'
    253: 0,  # 'ż'
    254: 0,  # 'Ģ'
    255: 0,  # 'ˇ'
}

MACLATIN2_SLOVAK_MODEL = SingleByteCharSetModel(
    charset_name="MacLatin2",
    language="Slovak",
    char_to_order_map=MACLATIN2_SLOVAK_CHAR_TO_ORDER,
    language_model=SLOVAK_LANG_MODEL,
    typical_positive_ratio=0.935065537950628,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÄÉÍÓÔÚÝáäéíóôúýČčĎďĹĺĽľŇňŔŕŠšŤťŽž",
)

WINDOWS_1250_SLOVAK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 36,  # 'A'
    66: 46,  # 'B'
    67: 50,  # 'C'
    68: 43,  # 'D'
    69: 49,  # 'E'
    70: 59,  # 'F'
    71: 62,  # 'G'
    72: 55,  # 'H'
    73: 52,  # 'I'
    74: 57,  # 'J'
    75: 42,  # 'K'
    76: 54,  # 'L'
    77: 40,  # 'M'
    78: 39,  # 'N'
    79: 44,  # 'O'
    80: 33,  # 'P'
    81: 75,  # 'Q'
    82: 45,  # 'R'
    83: 35,  # 'S'
    84: 41,  # 'T'
    85: 60,  # 'U'
    86: 37,  # 'V'
    87: 65,  # 'W'
    88: 70,  # 'X'
    89: 67,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 22,  # 'b'
    99: 16,  # 'c'
    100: 12,  # 'd'
    101: 3,  # 'e'
    102: 34,  # 'f'
    103: 32,  # 'g'
    104: 17,  # 'h'
    105: 5,  # 'i'
    106: 19,  # 'j'
    107: 10,  # 'k'
    108: 11,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 1,  # 'o'
    112: 14,  # 'p'
    113: 76,  # 'q'
    114: 6,  # 'r'
    115: 9,  # 's'
    116: 7,  # 't'
    117: 15,  # 'u'
    118: 8,  # 'v'
    119: 61,  # 'w'
    120: 56,  # 'x'
    121: 21,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 64,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Ś'
    141: 80,  # 'Ť'
    142: 68,  # 'Ž'
    143: 0,  # 'Ź'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 28,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'ś'
    157: 30,  # 'ť'
    158: 26,  # 'ž'
    159: 0,  # 'ź'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'ˇ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ą'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ş'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ą'
    186: 0,  # 'ş'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 73,  # 'Ľ'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 31,  # 'ľ'
    191: 0,  # 'ż'
    192: 86,  # 'Ŕ'
    193: 71,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 84,  # 'Ä'
    197: 85,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 63,  # 'Č'
    201: 78,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 77,  # 'Í'
    206: 0,  # 'Î'
    207: 74,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 82,  # 'Ň'
    211: 81,  # 'Ó'
    212: 83,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 66,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 79,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 72,  # 'ŕ'
    225: 18,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 58,  # 'ä'
    229: 69,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 25,  # 'č'
    233: 27,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 23,  # 'í'
    238: 0,  # 'î'
    239: 51,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 47,  # 'ň'
    243: 48,  # 'ó'
    244: 38,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 29,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 24,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1250_SLOVAK_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1250",
    language="Slovak",
    char_to_order_map=WINDOWS_1250_SLOVAK_CHAR_TO_ORDER,
    language_model=SLOVAK_LANG_MODEL,
    typical_positive_ratio=0.935065537950628,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÁÄÉÍÓÔÚÝáäéíóôúýČčĎďĹĺĽľŇňŔŕŠšŤťŽž",
)
