/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public final class Segment {
    private final LocalDateTime start;
    private final LocalDateTime end;
    private final Fraction value;
    private final TimeDirection direction;

    private Segment(TimeDirection direction, LocalDateTime start, LocalDateTime end, Fraction value) {
        Objects.requireNonNull(value);
        this.direction = direction;
        this.start = start;
        this.end = end;
        this.value = value;
    }

    public static Segment forward(LocalDateTime start, LocalDateTime end, Fraction value) {
        if (!start.isBefore(end)) {
            throw new IllegalArgumentException("end must be after start");
        }
        return new Segment(TimeDirection.FORWARD, start, end, value);
    }

    public static Segment backward(LocalDateTime start, LocalDateTime end, Fraction value) {
        if (!end.isBefore(start)) {
            throw new IllegalArgumentException("end must be before start");
        }
        return new Segment(TimeDirection.BACKWARD, start, end, value);
    }

    public TimeDirection getTimeDirection() {
        return this.direction;
    }

    public LocalDateTime startExclusive() {
        return this.start;
    }

    public LocalDateTime endExclusive() {
        return this.end;
    }

    public Fraction getValue() {
        return this.value;
    }

    public Segment[] split(LocalDateTime time) {
        Objects.requireNonNull(time, "time must not be null");
        if (!this.includes(time)) {
            throw new IllegalArgumentException("time must be within the segment bounds");
        }
        if (this.direction == TimeDirection.FORWARD) {
            Segment first = Segment.forward(this.start, time, this.value);
            Segment second = Segment.forward(time, this.end, this.value);
            return new Segment[]{first, second};
        }
        Segment first = Segment.backward(this.start, time, this.value);
        Segment second = Segment.backward(time, this.end, this.value);
        return new Segment[]{first, second};
    }

    public boolean includes(LocalDateTime time) {
        Objects.requireNonNull(time, "time must not be null");
        if (this.direction == TimeDirection.FORWARD) {
            return time.isAfter(this.start) && time.isBefore(this.end);
        }
        return time.isBefore(this.start) && time.isAfter(this.end);
    }

    public String toString() {
        return (Object)((Object)this.getTimeDirection()) + " ]" + this.start + ", " + this.end + "[ value=" + this.value;
    }

    public static Segment intersection(List<Segment> segments) {
        return Segment.intersection(segments, Fraction.PRODUCT);
    }

    public static Segment intersection(List<Segment> segments, BiFunction<Fraction, Fraction, Fraction> valueFunction) {
        Objects.requireNonNull(valueFunction, "valueFunction must not be null");
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("No segments to intersect");
        }
        if (segments.size() == 1) {
            return segments.get(0);
        }
        TimeDirection direction = segments.get(0).getTimeDirection();
        LocalDateTime start = segments.get(0).startExclusive();
        LocalDateTime end = segments.get(0).endExclusive();
        Fraction combinedValue = segments.get(0).getValue();
        for (int i = 1; i < segments.size(); ++i) {
            Segment segment = segments.get(i);
            if (segment.getTimeDirection() != direction) {
                throw new IllegalArgumentException("All segments must have the same direction");
            }
            if (direction == TimeDirection.FORWARD) {
                if (segment.startExclusive().isAfter(start)) {
                    start = segment.startExclusive();
                }
                if (segment.endExclusive().isBefore(end)) {
                    end = segment.endExclusive();
                }
            } else {
                if (segment.startExclusive().isBefore(start)) {
                    start = segment.startExclusive();
                }
                if (segment.endExclusive().isAfter(end)) {
                    end = segment.endExclusive();
                }
            }
            combinedValue = valueFunction.apply(combinedValue, segment.getValue());
        }
        if (direction == TimeDirection.FORWARD) {
            if (!start.isBefore(end)) {
                throw new IllegalArgumentException("Segments do not overlap");
            }
            return Segment.forward(start, end, combinedValue);
        }
        if (!end.isBefore(start)) {
            throw new IllegalArgumentException("Segments do not overlap");
        }
        return Segment.backward(start, end, combinedValue);
    }

    public static Segment intersection(Segment[] segments) {
        Objects.requireNonNull(segments, "segments must not be null");
        return Segment.intersection(Arrays.asList(segments));
    }

    public static Segment intersection(Segment[] segments, BiFunction<Fraction, Fraction, Fraction> valueFunction) {
        Objects.requireNonNull(segments, "segments must not be null");
        return Segment.intersection(Arrays.asList(segments), valueFunction);
    }

    public LocalDateTime computeClampedStart(LocalDateTime current) {
        if (this.direction == TimeDirection.FORWARD) {
            return current.isAfter(this.startExclusive()) ? current : this.startExclusive();
        }
        return current.isBefore(this.startExclusive()) ? current : this.startExclusive();
    }
}

