/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.wire.WireDiagram;

public class CommandSpot
extends SingleLineCommand2<WireDiagram> {
    public CommandSpot() {
        super(false, CommandSpot.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSpot.class.getName(), RegexLeaf.start(), new RegexLeaf("spot"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "NAME", "([\\w][.\\w]*)"), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("\\("), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(2, "X", "(-?\\d+(%|%[-+]\\d+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(2, "Y", "(-?\\d+(%|%[-+]\\d+)?)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "COLOR", "(#\\w+)?"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WireDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String name = arg.get("NAME", 0);
        String stringColor = arg.get("COLOR", 0);
        HColor color = null;
        if (stringColor != null) {
            color = HColorSet.instance().getColor(stringColor);
        }
        String x = arg.get("X", 0);
        String y = arg.get("Y", 0);
        return diagram.spot(name, color, x, y);
    }
}

