/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context.navigate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;

public class MessageLookup<T>
implements ContextDataLookupFunction<MessageContext, T> {
    @Nonnull
    private final Class<T> messageType;

    public MessageLookup(@Nonnull @ParameterName(name="type") Class<T> type) {
        this.messageType = Constraint.isNotNull(type, "Message type cannot be null");
    }

    @Override
    @Nullable
    public T apply(@Nullable MessageContext input) {
        if (input != null && this.messageType.isInstance(input.getMessage())) {
            return this.messageType.cast(input.getMessage());
        }
        return null;
    }
}

