/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.health.ClusterHealthAction;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.AlertingV2Utils;
import org.opensearch.alerting.MonitorMetadataService;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.service.DeleteMonitorService;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportIndexMonitorAction;
import org.opensearch.alerting.transport.TransportIndexMonitorActionKt;
import org.opensearch.alerting.util.AlertingUtilsKt;
import org.opensearch.alerting.util.AnomalyDetectionUtilsKt;
import org.opensearch.alerting.util.DocLevelMonitorQueries;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.MonitorMetadata;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.alerting.model.action.Throttle;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequestBuilder;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001EBQ\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J&\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00022\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030?H\u0014J.\u0010@\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030?2\u0006\u0010=\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010CJ.\u0010D\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030?2\u0006\u0010=\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010CR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0018\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u0016\u0010+\u001a\n )*\u0004\u0018\u00010,0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n )*\u0004\u0018\u00010,0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\n )*\u0004\u0018\u00010,0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\u0016\u0012\u0004\u0012\u000201 )*\n\u0012\u0004\u0012\u000201\u0018\u00010000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\n )*\u0004\u0018\u00010303X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u00108\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006F"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/commons/alerting/action/IndexMonitorResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "docLevelMonitorQueries", "Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/core/ScheduledJobIndices;Lorg/opensearch/alerting/util/DocLevelMonitorQueries;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getDocLevelMonitorQueries", "()Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "maxMonitors", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "requestTimeout", "Lorg/opensearch/common/unit/TimeValue;", "indexTimeout", "maxActionThrottle", "allowList", "", "", "filterByEnabled", "", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "checkIndicesAndExecute", "Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "checkAnomalyDetectorAndExecute", "IndexMonitorHandler", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportIndexMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction\n+ 2 TransportHelpers.kt\norg/opensearch/commons/utils/TransportHelpersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 AlertingUtils.kt\norg/opensearch/alerting/util/AlertingUtilsKt\n*L\n1#1,767:1\n48#2,5:768\n774#3:773\n865#3,2:774\n1869#3,2:776\n1563#3:778\n1634#3,3:779\n37#4:782\n36#4,3:783\n173#5,8:786\n*S KotlinDebug\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction\n*L\n127#1:768,5\n191#1:773\n191#1:774,2\n196#1:776,2\n202#1:778\n202#1:779,3\n210#1:782\n210#1:783,3\n255#1:786,8\n*E\n"})
public final class TransportIndexMonitorAction
extends HandledTransportAction<ActionRequest, IndexMonitorResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final ScheduledJobIndices scheduledJobIndices;
    @NotNull
    private final DocLevelMonitorQueries docLevelMonitorQueries;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile Integer maxMonitors;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue indexTimeout;
    private volatile TimeValue maxActionThrottle;
    private volatile List<String> allowList;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexMonitorAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ScheduledJobIndices scheduledJobIndices, @NotNull DocLevelMonitorQueries docLevelMonitorQueries, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"scheduledJobIndices");
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorQueries, (String)"docLevelMonitorQueries");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opendistro/alerting/monitor/write", transportService, actionFilters, IndexMonitorRequest::new);
        this.client = client;
        this.scheduledJobIndices = scheduledJobIndices;
        this.docLevelMonitorQueries = docLevelMonitorQueries;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.maxMonitors = (Integer)AlertingSettings.Companion.getALERTING_MAX_MONITORS().get(this.settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
        this.maxActionThrottle = (TimeValue)AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE().get(this.settings);
        this.allowList = (List)DestinationSettings.Companion.getALLOW_LIST().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERTING_MAX_MONITORS(), arg_0 -> TransportIndexMonitorAction._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> TransportIndexMonitorAction._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexMonitorAction._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), arg_0 -> TransportIndexMonitorAction._init_$lambda$3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DestinationSettings.Companion.getALLOW_LIST(), arg_0 -> TransportIndexMonitorAction._init_$lambda$4(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        return this.scheduledJobIndices;
    }

    @NotNull
    public final DocLevelMonitorQueries getDocLevelMonitorQueries() {
        return this.docLevelMonitorQueries;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(@NotNull Task task, @NotNull ActionRequest request, @NotNull ActionListener<IndexMonitorResponse> actionListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void checkIndicesAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        indices = new ArrayList<E>();
        $this$filter$iv = request.getMonitor().getInputs();
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var12_17 = $this$filterTo$iv$iv.iterator();
        while (var12_17.hasNext()) {
            element$iv$iv = var12_17.next();
            it = (Input)element$iv$iv;
            $i$a$-filter-TransportIndexMonitorAction$checkIndicesAndExecute$searchInputs$1 = false;
            if (!(Intrinsics.areEqual((Object)it.name(), (Object)"search") != false || Intrinsics.areEqual((Object)it.name(), (Object)"doc_level_input") != false || Intrinsics.areEqual((Object)it.name(), (Object)"remote_doc_level_monitor_input") != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        searchInputs = (List)destination$iv$iv;
        $this$forEach$iv = searchInputs;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Input)element$iv /* !! */ ;
            $i$a$-forEach-TransportIndexMonitorAction$checkIndicesAndExecute$1 = false;
            if (Intrinsics.areEqual((Object)it.name(), (Object)"search")) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.SearchInput");
                v0 = ((SearchInput)it).getIndices();
            } else if (Intrinsics.areEqual((Object)it.name(), (Object)"doc_level_input")) {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.DocLevelMonitorInput");
                v0 = ((DocLevelMonitorInput)it).getIndices();
            } else {
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.remote.monitors.RemoteDocLevelMonitorInput");
                v0 = ((RemoteDocLevelMonitorInput)it).getDocLevelMonitorInput().getIndices();
            }
            inputIndices = v0;
            indices.addAll(inputIndices);
        }
        $this$map$iv = indices;
        $i$f$map = false;
        element$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            $i$a$-filter-TransportIndexMonitorAction$checkIndicesAndExecute$searchInputs$1 = (String)item$iv$iv;
            var18_28 = destination$iv$iv;
            $i$a$-map-TransportIndexMonitorAction$checkIndicesAndExecute$updatedIndices$1 = false;
            v1 = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"state(...)");
            if (IndexUtils.Companion.isAlias((String)index, v1)) ** GOTO lbl-1000
            v2 = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"state(...)");
            if (IndexUtils.Companion.isDataStream((String)index, v2)) lbl-1000:
            // 2 sources

            {
                v3 = (IndexAbstraction)this.clusterService.state().getMetadata().getIndicesLookup().get(index);
                metadata /* !! */  = v3 != null ? v3.getWriteIndex() : null;
                v4 /* !! */  = metadata /* !! */ ;
                if (v4 /* !! */  == null || (v4 /* !! */  = v4 /* !! */ .getIndex()) == null || (v4 /* !! */  = v4 /* !! */ .getName()) == null) {
                    v4 /* !! */  = index;
                }
            } else {
                v4 /* !! */  = index;
            }
            var18_28.add(v4 /* !! */ );
        }
        updatedIndices = (List)destination$iv$iv;
        $this$toTypedArray$iv = updatedIndices;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        var9_11 = thisCollection$iv.toArray(new String[0]);
        searchRequest = new SearchRequest().indices(Arrays.copyOf(var9_11, var9_11.length)).source(SearchSourceBuilder.searchSource().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(client, this, actionListener, request, user, (List<String>)indices){
            final /* synthetic */ Client $client;
            final /* synthetic */ TransportIndexMonitorAction this$0;
            final /* synthetic */ ActionListener<IndexMonitorResponse> $actionListener;
            final /* synthetic */ IndexMonitorRequest $request;
            final /* synthetic */ User $user;
            final /* synthetic */ List<String> $indices;
            {
                this.$client = $client;
                this.this$0 = $receiver;
                this.$actionListener = $actionListener;
                this.$request = $request;
                this.$user = $user;
                this.$indices = $indices;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void onResponse(SearchResponse searchResponse) {
                void $this$use$iv;
                Intrinsics.checkNotNullParameter((Object)searchResponse, (String)"searchResponse");
                ThreadContext.StoredContext storedContext = this.$client.threadPool().getThreadContext().stashContext();
                TransportIndexMonitorAction transportIndexMonitorAction = this.this$0;
                Client client = this.$client;
                ActionListener<IndexMonitorResponse> actionListener = this.$actionListener;
                IndexMonitorRequest indexMonitorRequest = this.$request;
                User user = this.$user;
                boolean $i$f$use = false;
                Throwable exception$iv = null;
                try {
                    void it = $this$use$iv;
                    boolean bl = false;
                    transportIndexMonitorAction.new IndexMonitorHandler(client, actionListener, indexMonitorRequest, user).resolveUserAndStart();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable e$iv) {
                    exception$iv = e$iv;
                    throw e$iv;
                }
                finally {
                    AlertingUtilsKt.closeFinally((ThreadContext.StoredContext)$this$use$iv, exception$iv);
                }
            }

            public void onFailure(Exception t) {
                Exception exception;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                boolean bl = t instanceof OpenSearchSecurityException;
                if (bl) {
                    exception = (Exception)new OpenSearchStatusException("User doesn't have read permissions for one or more configured index " + this.$indices, RestStatus.FORBIDDEN, new Object[0]);
                } else if (!bl) {
                    exception = t;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(exception));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkAnomalyDetectorAndExecute(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @NotNull IndexMonitorRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ThreadContext.StoredContext $this$use$iv = client.threadPool().getThreadContext().stashContext();
        boolean $i$f$use = false;
        Throwable exception$iv = null;
        try {
            ThreadContext.StoredContext it = $this$use$iv;
            boolean bl = false;
            new IndexMonitorHandler(client, actionListener, request, user).resolveUserAndStartForAD();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            exception$iv = e$iv;
            throw e$iv;
        }
        finally {
            AlertingUtilsKt.closeFinally($this$use$iv, exception$iv);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.super.listenFilterBySettingChange(clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.super.readUserFromThreadContext(client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.super.doFilterForUser(user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.super.isAdmin(user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.super.validateUserBackendRoles(user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.super.checkUserPermissionsWithResource(requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportIndexMonitorAction this$0, Integer it) {
        this$0.maxMonitors = it;
    }

    private static final void _init_$lambda$1(TransportIndexMonitorAction this$0, TimeValue it) {
        this$0.requestTimeout = it;
    }

    private static final void _init_$lambda$2(TransportIndexMonitorAction this$0, TimeValue it) {
        this$0.indexTimeout = it;
    }

    private static final void _init_$lambda$3(TransportIndexMonitorAction this$0, TimeValue it) {
        this$0.maxActionThrottle = it;
    }

    private static final void _init_$lambda$4(TransportIndexMonitorAction this$0, List it) {
        this$0.allowList = it;
    }

    private static final boolean doExecute$lambda$6(User $user, String it) {
        return !$user.getBackendRoles().contains(it);
    }

    private static final boolean doExecute$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ TimeValue access$getIndexTimeout$p(TransportIndexMonitorAction $this) {
        return $this.indexTimeout;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010%J.\u0010&\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0082@\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010!J\u0016\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u0004\u0018\u00010(2\u0006\u0010\u0019\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler;", "", "client", "Lorg/opensearch/transport/client/Client;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/commons/alerting/action/IndexMonitorResponse;", "request", "Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Lorg/opensearch/alerting/transport/TransportIndexMonitorAction;Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/commons/alerting/action/IndexMonitorRequest;Lorg/opensearch/commons/authuser/User;)V", "resolveUserAndStart", "", "resolveUserAndStartForAD", "start", "prepareMonitorIndexing", "validateActionThrottle", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "maxValue", "Lorg/opensearch/common/unit/TimeValue;", "minValue", "onSearchResponse", "response", "Lorg/opensearch/action/search/SearchResponse;", "onCreateMappingsResponse", "isAcknowledged", "", "onUpdateMappingsResponse", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "indexMonitor", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupMonitorAfterPartialFailure", "indexMonitorResponse", "Lorg/opensearch/action/index/IndexResponse;", "(Lorg/opensearch/commons/alerting/model/Monitor;Lorg/opensearch/action/index/IndexResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexDocLevelMonitorQueries", "monitorId", "", "monitorMetadata", "Lorg/opensearch/commons/alerting/model/MonitorMetadata;", "refreshPolicy", "Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;", "(Lorg/opensearch/commons/alerting/model/Monitor;Ljava/lang/String;Lorg/opensearch/commons/alerting/model/MonitorMetadata;Lorg/opensearch/action/support/WriteRequest$RefreshPolicy;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateMonitor", "onGetResponse", "currentMonitor", "(Lorg/opensearch/commons/alerting/model/Monitor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkShardsFailure", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nTransportIndexMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,767:1\n1869#2:768\n1869#2,2:769\n1870#2:771\n13472#3,2:772\n*S KotlinDebug\n*F\n+ 1 TransportIndexMonitorAction.kt\norg/opensearch/alerting/transport/TransportIndexMonitorAction$IndexMonitorHandler\n*L\n412#1:768\n413#1:769,2\n412#1:771\n757#1:772,2\n*E\n"})
    public final class IndexMonitorHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexMonitorResponse> actionListener;
        @NotNull
        private final IndexMonitorRequest request;
        @Nullable
        private final User user;

        public IndexMonitorHandler(@NotNull Client client, @NotNull ActionListener<IndexMonitorResponse> actionListener, @Nullable IndexMonitorRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public final void resolveUserAndStart() {
            if (this.user == null) {
                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User("", CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                this.start();
            } else {
                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttributes()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                this.start();
            }
        }

        public final void resolveUserAndStartForAD() {
            if (this.user == null) {
                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User("", CollectionsKt.emptyList(), CollectionsKt.emptyList(), MapsKt.emptyMap()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                this.start();
            } else {
                try {
                    this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), this.user.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttributes()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0);
                    if (AlertingUtilsKt.getRoleFilterEnabled(TransportIndexMonitorAction.this.getClusterService(), TransportIndexMonitorAction.this.getSettings(), "plugins.anomaly_detection.filter_by_backend_roles")) {
                        Intrinsics.checkNotNull((Object)searchSourceBuilder);
                        AnomalyDetectionUtilsKt.addUserBackendRolesFilter(this.user, searchSourceBuilder);
                    }
                    String[] stringArray = new String[]{".opendistro-anomaly-detectors"};
                    SearchRequest searchRequest = new SearchRequest().indices(stringArray).source(searchSourceBuilder);
                    this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                        final /* synthetic */ IndexMonitorHandler this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onResponse(SearchResponse response2) {
                            Long totalHits;
                            SearchResponse searchResponse = response2;
                            Long l = searchResponse != null && (searchResponse = searchResponse.getHits()) != null && (searchResponse = searchResponse.getTotalHits()) != null ? Long.valueOf(searchResponse.value()) : (totalHits = null);
                            if (totalHits != null && totalHits > 0L) {
                                this.this$0.start();
                            } else {
                                IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("User has no available detectors", RestStatus.NOT_FOUND, new Object[0])));
                            }
                        }

                        public void onFailure(Exception t) {
                            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                            IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                        }
                    });
                }
                catch (IOException ex) {
                    this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)ex));
                }
            }
        }

        public final void start() {
            if (!TransportIndexMonitorAction.this.getScheduledJobIndices().scheduledJobIndexExists()) {
                TransportIndexMonitorAction.this.getScheduledJobIndices().initScheduledJobIndex((ActionListener)new ActionListener<CreateIndexResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(CreateIndexResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onCreateMappingsResponse(this.this$0, response2.isAcknowledged());
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (ExceptionsHelper.unwrapCause((Throwable)t) instanceof ResourceAlreadyExistsException) {
                            BuildersKt.launch$default((CoroutineScope)TransportIndexMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ IndexMonitorHandler this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var3_3 = new String[]{".opendistro-alerting-config"};
                                            request = new ClusterHealthRequest().indices(var3_3).waitForYellowStatus();
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                                            this.label = 1;
                                            v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)IndexMonitorHandler.access$getClient$p(this.this$0)), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(org.opensearch.action.admin.cluster.health.ClusterHealthRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((ClusterHealthRequest)request), (Continuation)((Continuation)this));
                                            if (v0 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl17
                                        }
                                        case 1: {
                                            request = (ClusterHealthRequest)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl17:
                                            // 2 sources

                                            if ((response = (ClusterHealthResponse)v0).isTimedOut()) {
                                                IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new OpenSearchException("Cannot determine that the .opendistro-alerting-config index is healthy", new Object[0]));
                                            }
                                            IndexMonitorHandler.access$onCreateMappingsResponse(this.this$0, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(ClusterHealthRequest $request, Client $this$suspendUntil, ActionListener it) {
                                    $this$suspendUntil.execute((ActionType)ClusterHealthAction.INSTANCE, (ActionRequest)$request, it);
                                    return Unit.INSTANCE;
                                }
                            }), (int)3, null);
                        } else {
                            IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                        }
                    }
                });
            } else if (!IndexUtils.Companion.getScheduledJobIndexUpdated()) {
                String string = ScheduledJobIndices.Companion.scheduledJobMappings();
                ClusterState clusterState = TransportIndexMonitorAction.this.getClusterService().state();
                Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"state(...)");
                IndicesAdminClient indicesAdminClient = this.client.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)indicesAdminClient, (String)"indices(...)");
                IndexUtils.Companion.updateIndexMapping(".opendistro-alerting-config", string, clusterState, indicesAdminClient, (ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMonitorHandler.access$onUpdateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                }));
            } else {
                this.prepareMonitorIndexing();
            }
        }

        private final void prepareMonitorIndexing() {
            try {
                Monitor monitor = this.request.getMonitor();
                TimeValue timeValue = TransportIndexMonitorAction.this.maxActionThrottle;
                Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"access$getMaxActionThrottle$p(...)");
                TimeValue timeValue2 = TimeValue.timeValueMinutes((long)1L);
                Intrinsics.checkNotNullExpressionValue((Object)timeValue2, (String)"timeValueMinutes(...)");
                this.validateActionThrottle(monitor, timeValue, timeValue2);
            }
            catch (RuntimeException e) {
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)e));
                return;
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                BuildersKt.launch$default((CoroutineScope)TransportIndexMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = IndexMonitorHandler.access$updateMonitor(this.this$0, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else {
                BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"monitor.type", (String)"monitor"));
                SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).timeout(TransportIndexMonitorAction.this.requestTimeout);
                String[] stringArray = new String[]{".opendistro-alerting-config"};
                SearchRequest searchRequest = new SearchRequest(stringArray).source(searchSource);
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(SearchResponse searchResponse) {
                        Intrinsics.checkNotNullParameter((Object)searchResponse, (String)"searchResponse");
                        IndexMonitorHandler.access$onSearchResponse(this.this$0, searchResponse);
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        IndexMonitorHandler.access$getActionListener$p(this.this$0).onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                });
            }
        }

        private final void validateActionThrottle(Monitor monitor, TimeValue maxValue, TimeValue minValue) {
            Iterable $this$forEach$iv = monitor.getTriggers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Trigger trigger = (Trigger)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = trigger.getActions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Action action = (Action)element$iv2;
                    boolean bl2 = false;
                    if (action.getThrottle() == null) continue;
                    Throttle throttle = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle);
                    long l = throttle.getValue();
                    Throttle throttle2 = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle2);
                    if (!(new TimeValue(Duration.of(l, throttle2.getUnit()).toMillis()).compareTo(maxValue) <= 0)) {
                        boolean $i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32 = false;
                        String $i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32 = "Can only set throttle period less than or equal to " + maxValue;
                        throw new IllegalArgumentException($i$a$-require-TransportIndexMonitorAction$IndexMonitorHandler$validateActionThrottle$1$1$32.toString());
                    }
                    Throttle throttle3 = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle3);
                    long l2 = throttle3.getValue();
                    Throttle throttle4 = action.getThrottle();
                    Intrinsics.checkNotNull((Object)throttle4);
                    if (new TimeValue(Duration.of(l2, throttle4.getUnit()).toMillis()).compareTo(minValue) >= 0) continue;
                    boolean bl3 = false;
                    String string = "Can only set throttle period greater than or equal to " + minValue;
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        private final void onSearchResponse(SearchResponse response2) {
            Long totalHits;
            TotalHits totalHits2 = response2.getHits().getTotalHits();
            Long l = totalHits = totalHits2 != null ? Long.valueOf(totalHits2.value()) : null;
            if (totalHits != null && totalHits >= (long)TransportIndexMonitorAction.this.maxMonitors.intValue()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalArgumentException("This request would create more than the allowed monitors [" + TransportIndexMonitorAction.this.maxMonitors + "].")));
            } else {
                BuildersKt.launch$default((CoroutineScope)TransportIndexMonitorActionKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = IndexMonitorHandler.access$indexMonitor(this.this$0, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }

        private final void onCreateMappingsResponse(boolean isAcknowledged) {
            if (isAcknowledged) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Created .opendistro-alerting-config with mappings.");
                this.prepareMonitorIndexing();
                IndexUtils.Companion.scheduledJobIndexUpdated();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().info("Create .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Create .opendistro-alerting-config mappings call not acknowledged", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private final void onUpdateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexMonitorActionKt.access$getLog$p().info("Updated  .opendistro-alerting-config with mappings.");
                IndexUtils.Companion.scheduledJobIndexUpdated();
                this.prepareMonitorIndexing();
            } else {
                TransportIndexMonitorActionKt.access$getLog$p().info("Update .opendistro-alerting-config mappings call not acknowledged.");
                this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Updated .opendistro-alerting-config mappings call not acknowledged.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        /*
         * Exception decompiling
         */
        private final Object indexMonitor(Continuation<? super Unit> $completion) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[SWITCH], 15[CASE]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Unable to fully structure code
         */
        private final Object cleanupMonitorAfterPartialFailure(Monitor monitor, IndexResponse indexMonitorResponse, Continuation<? super Unit> $completion) {
            if (!($completion instanceof cleanupMonitorAfterPartialFailure.1)) ** GOTO lbl-1000
            var6_4 = $completion;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$cleanupMonitorAfterPartialFailure(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)monitor);
                    $continuation.L$1 = indexMonitorResponse;
                    $continuation.label = 1;
                    v0 = DeleteMonitorService.INSTANCE.deleteMonitor(monitor, WriteRequest.RefreshPolicy.IMMEDIATE, (Continuation<? super DeleteMonitorResponse>)$continuation);
                    ** if (v0 != var7_6) goto lbl20
lbl19:
                    // 1 sources

                    return var7_6;
lbl20:
                    // 1 sources

                    ** GOTO lbl28
                }
                case 1: {
                    indexMonitorResponse = (IndexResponse)$continuation.L$1;
                    monitor = (Monitor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        TransportIndexMonitorActionKt.access$getLog$p().debug("Cleaned up monitor related resources after monitor creation request partial failure. Monitor id : " + indexMonitorResponse.getId());
                    }
                    catch (Exception e) {
                        TransportIndexMonitorActionKt.access$getLog$p().error("Failed to clean up monitor after monitor creation request partial failure", (Throwable)e);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object indexDocLevelMonitorQueries(Monitor monitor, String monitorId, MonitorMetadata monitorMetadata, WriteRequest.RefreshPolicy refreshPolicy, Continuation<? super Unit> $completion) {
            if (!($completion instanceof indexDocLevelMonitorQueries.1)) ** GOTO lbl-1000
            var8_6 = $completion;
            if ((var8_6.label & -2147483648) != 0) {
                var8_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$indexDocLevelMonitorQueries(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    queryIndex = monitor.getDataSources().getQueryIndex();
                    if (TransportIndexMonitorAction.this.getDocLevelMonitorQueries().docLevelQueryIndexExists(monitor.getDataSources())) ** GOTO lbl33
                    $continuation.L$0 = monitor;
                    $continuation.L$1 = monitorId;
                    $continuation.L$2 = monitorMetadata;
                    $continuation.L$3 = refreshPolicy;
                    $continuation.L$4 = queryIndex;
                    $continuation.label = 1;
                    v0 = TransportIndexMonitorAction.this.getDocLevelMonitorQueries().initDocLevelQueryIndex(monitor.getDataSources(), (Continuation<? super Boolean>)$continuation);
                    if (v0 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    queryIndex = (String)$continuation.L$4;
                    refreshPolicy = (WriteRequest.RefreshPolicy)$continuation.L$3;
                    monitorMetadata = (MonitorMetadata)$continuation.L$2;
                    monitorId = (String)$continuation.L$1;
                    monitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    TransportIndexMonitorActionKt.access$getLog$p().info("Central Percolation index " + queryIndex + " created");
lbl33:
                    // 2 sources

                    v1 = TransportIndexMonitorAction.this.getDocLevelMonitorQueries();
                    v2 = TransportIndexMonitorAction.access$getIndexTimeout$p(TransportIndexMonitorAction.this);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"access$getIndexTimeout$p(...)");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)monitor);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)monitorId);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)monitorMetadata);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)refreshPolicy);
                    $continuation.L$4 = queryIndex;
                    $continuation.label = 2;
                    v3 = v1.indexDocLevelQueries(monitor, monitorId, monitorMetadata, refreshPolicy, v2, (Continuation<? super Unit>)$continuation);
                    if (v3 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl54
                }
                case 2: {
                    queryIndex = (String)$continuation.L$4;
                    refreshPolicy = (WriteRequest.RefreshPolicy)$continuation.L$3;
                    monitorMetadata = (MonitorMetadata)$continuation.L$2;
                    monitorId = (String)$continuation.L$1;
                    monitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl54:
                    // 2 sources

                    TransportIndexMonitorActionKt.access$getLog$p().debug("Queries inserted into Percolate index " + queryIndex);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object updateMonitor(Continuation<? super Unit> $completion) {
            if (!($completion instanceof updateMonitor.1)) ** GOTO lbl-1000
            var10_2 = $completion;
            if ((var10_2.label & -2147483648) != 0) {
                var10_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$updateMonitor(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    getRequest = new GetRequest(".opendistro-alerting-config", this.request.getMonitorId());
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, updateMonitor$lambda$5(org.opensearch.alerting.transport.TransportIndexMonitorAction$IndexMonitorHandler org.opensearch.action.get.GetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexMonitorHandler)this, (GetRequest)getRequest), (Continuation)$continuation);
                    ** if (v0 != var11_4) goto lbl20
lbl19:
                    // 1 sources

                    return var11_4;
lbl20:
                    // 1 sources

                    ** GOTO lbl27
                }
                case 1: {
                    getRequest = (GetRequest)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    if (!(getResponse = (GetResponse)v0).isExists()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Monitor with " + this.request.getMonitorId() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return Unit.INSTANCE;
                    }
                    xcp = XContentHelper.createParser((NamedXContentRegistry)TransportIndexMonitorAction.this.getXContentRegistry(), (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                    Intrinsics.checkNotNull((Object)xcp);
                    v1 = getResponse.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getId(...)");
                    scheduledJob = ScheduledJob.Companion.parse(xcp, v1, getResponse.getVersion());
                    v2 = AlertingV2Utils.INSTANCE.validateMonitorV1(scheduledJob);
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-TransportIndexMonitorAction$IndexMonitorHandler$updateMonitor$2 = false;
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(it));
                        return Unit.INSTANCE;
                    }
                    Intrinsics.checkNotNull((Object)scheduledJob, (String)"null cannot be cast to non-null type org.opensearch.commons.alerting.model.Monitor");
                    monitor = (Monitor)scheduledJob;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)getResponse);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)xcp);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)scheduledJob);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)monitor);
                    $continuation.label = 2;
                    v3 = this.onGetResponse(monitor, (Continuation<? super Unit>)$continuation);
                    ** if (v3 != var11_4) goto lbl52
lbl51:
                    // 1 sources

                    return var11_4;
lbl52:
                    // 1 sources

                    ** GOTO lbl66
                }
                case 2: {
                    monitor = (Monitor)$continuation.L$4;
                    scheduledJob = (ScheduledJob)$continuation.L$3;
                    xcp = (XContentParser)$continuation.L$2;
                    getResponse = (GetResponse)$continuation.L$1;
                    getRequest = (GetRequest)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
lbl66:
                    // 3 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object onGetResponse(Monitor currentMonitor, Continuation<? super Unit> $completion) {
            if (!($completion instanceof onGetResponse.1)) ** GOTO lbl-1000
            var13_3 = $completion;
            if ((var13_3.label & -2147483648) != 0) {
                var13_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    boolean Z$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexMonitorHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexMonitorHandler.access$onGetResponse(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!TransportIndexMonitorAction.this.checkUserPermissionsWithResource(this.user, currentMonitor.getUser(), this.actionListener, "monitor", this.request.getMonitorId())) {
                        return Unit.INSTANCE;
                    }
                    if (this.request.getMonitor().getEnabled() && currentMonitor.getEnabled()) {
                        this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, (Instant)currentMonitor.getEnabledTime(), null, null, (int)0, null, null, null, null, null, null, null, (int)131007, null));
                    }
                    if (this.user != null) {
                        if (this.request.getRbacRoles() != null) {
                            if (TransportIndexMonitorAction.this.isAdmin(this.user)) {
                                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), this.request.getRbacRoles(), this.user.getRoles(), this.user.getCustomAttributes()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                            } else {
                                v0 = this.user.getBackendRoles();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getBackendRoles(...)");
                                v1 = v0;
                                v2 = this.request.getRbacRoles();
                                if (v2 == null) {
                                    v2 = CollectionsKt.emptyList();
                                }
                                rolesToRemove = CollectionsKt.minus((Iterable)v1, (Iterable)v2);
                                v3 = currentMonitor.getUser();
                                v4 = v3 != null ? v3.getBackendRoles() : null;
                                if (v4 == null) {
                                    v4 = CollectionsKt.emptyList();
                                }
                                v5 = CollectionsKt.minus((Iterable)v4, (Iterable)rolesToRemove);
                                v6 = this.request.getRbacRoles();
                                if (v6 == null) {
                                    v6 = CollectionsKt.emptyList();
                                }
                                updatedRbac = CollectionsKt.plus((Collection)v5, (Iterable)v6);
                                this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(this.user.getName(), updatedRbac, this.user.getRoles(), this.user.getCustomAttributes()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                            }
                        } else {
                            v7 = this.request.getMonitor();
                            v8 = this.user.getName();
                            v9 = currentMonitor.getUser();
                            Intrinsics.checkNotNull((Object)v9);
                            this.request.setMonitor(Monitor.copy$default((Monitor)v7, null, (long)0L, null, (boolean)false, null, null, null, null, (User)new User(v8, v9.getBackendRoles(), this.user.getRoles(), this.user.getCustomAttributes()), (int)0, null, null, null, null, null, null, null, (int)130815, null));
                        }
                        v10 = this.request.getMonitor().getUser();
                        TransportIndexMonitorActionKt.access$getLog$p().debug("Update monitor backend roles to: " + (v10 != null ? v10.getBackendRoles() : null));
                    }
                    this.request.setMonitor(Monitor.copy$default((Monitor)this.request.getMonitor(), null, (long)0L, null, (boolean)false, null, null, null, null, null, (int)IndexUtils.Companion.getScheduledJobIndexSchemaVersion(), null, null, null, null, null, null, null, (int)130559, null));
                    v11 = (IndexRequest)new IndexRequest(".opendistro-alerting-config").setRefreshPolicy(this.request.getRefreshPolicy());
                    v12 = this.request.getMonitor();
                    v13 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"jsonBuilder(...)");
                    indexRequest = (IndexRequest)v11.source(v12.toXContentWithUser(v13, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))))).id(this.request.getMonitorId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexMonitorAction.access$getIndexTimeout$p(TransportIndexMonitorAction.this));
                    v14 = TransportIndexMonitorActionKt.access$getLog$p();
                    v15 = currentMonitor.getId();
                    v16 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"jsonBuilder(...)");
                    v17 = currentMonitor.toXContentWithUser(v16, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true"))));
                    v18 = this.request.getMonitor();
                    v19 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"jsonBuilder(...)");
                    v14.info("Updating monitor, " + v15 + ", from: " + v17 + " \n to: " + v18.toXContentWithUser(v19, (ToXContent.Params)new ToXContent.MapParams(MapsKt.mapOf((Pair)TuplesKt.to((Object)"with_type", (Object)"true")))));
                    $continuation.L$0 = currentMonitor;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.label = 1;
                    v20 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, onGetResponse$lambda$7(org.opensearch.alerting.transport.TransportIndexMonitorAction$IndexMonitorHandler org.opensearch.action.index.IndexRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexMonitorHandler)this, (IndexRequest)indexRequest), (Continuation)$continuation);
                    ** if (v20 != var14_5) goto lbl69
lbl68:
                    // 1 sources

                    return var14_5;
lbl69:
                    // 1 sources

                    ** GOTO lbl77
                }
                case 1: {
                    indexRequest = (IndexRequest)$continuation.L$1;
                    currentMonitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v20 = $result;
lbl77:
                    // 2 sources

                    if ((failureReasons = this.checkShardsFailure(indexResponse = (IndexResponse)v20)) != null) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), indexResponse.status(), new Object[0])));
                        return Unit.INSTANCE;
                    }
                    isDocLevelMonitorRestarted = 0;
                    if (this.request.getMonitor().getEnabled() && !currentMonitor.getEnabled() && StringsKt.endsWith$default((String)this.request.getMonitor().getMonitorType(), (String)Monitor.MonitorType.DOC_LEVEL_MONITOR.getValue(), (boolean)false, (int)2, null)) {
                        isDocLevelMonitorRestarted = 1;
                    }
                    updatedMetadata = null;
                    $continuation.L$0 = currentMonitor;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.L$2 = indexResponse;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)failureReasons);
                    $continuation.I$0 = isDocLevelMonitorRestarted;
                    $continuation.label = 2;
                    v21 = MonitorMetadataService.getOrCreateMetadata$default(MonitorMetadataService.INSTANCE, this.request.getMonitor(), false, false, null, isDocLevelMonitorRestarted != 0, (Continuation)$continuation, 14, null);
                    ** if (v21 != var14_5) goto lbl93
lbl92:
                    // 1 sources

                    return var14_5;
lbl93:
                    // 1 sources

                    ** GOTO lbl105
                }
                case 2: {
                    isDocLevelMonitorRestarted = $continuation.I$0;
                    updatedMetadata = null;
                    failureReasons = (String)$continuation.L$3;
                    indexResponse = (IndexResponse)$continuation.L$2;
                    indexRequest = (IndexRequest)$continuation.L$1;
                    currentMonitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v21 = $result;
lbl105:
                    // 2 sources

                    var8_16 = (Pair)v21;
                    metadata = (MonitorMetadata)var8_16.component1();
                    created = (Boolean)var8_16.component2();
                    if (created || !IndexUtilsKt.isMonitorOfStandardType((Monitor)currentMonitor)) ** GOTO lbl220
                    var11_21 = currentMonitor.getMonitorType();
                    v22 = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"ROOT");
                    v23 = var11_21.toUpperCase(v22);
                    Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"toUpperCase(...)");
                    if (Monitor.MonitorType.valueOf((String)v23) != Monitor.MonitorType.DOC_LEVEL_MONITOR) ** GOTO lbl220
                    $continuation.L$0 = currentMonitor;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.L$2 = indexResponse;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)failureReasons);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                    $continuation.I$0 = isDocLevelMonitorRestarted;
                    $continuation.Z$0 = created;
                    $continuation.label = 3;
                    v24 = MonitorMetadataService.INSTANCE.recreateRunContext(metadata, currentMonitor, (Continuation<? super MonitorMetadata>)$continuation);
                    ** if (v24 != var14_5) goto lbl126
lbl125:
                    // 1 sources

                    return var14_5;
lbl126:
                    // 1 sources

                    ** GOTO lbl140
                }
                case 3: {
                    created = $continuation.Z$0;
                    isDocLevelMonitorRestarted = $continuation.I$0;
                    metadata = (MonitorMetadata)$continuation.L$4;
                    updatedMetadata = null;
                    failureReasons = (String)$continuation.L$3;
                    indexResponse = (IndexResponse)$continuation.L$2;
                    indexRequest = (IndexRequest)$continuation.L$1;
                    currentMonitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v24 = $result;
lbl140:
                    // 2 sources

                    updatedMetadata = (MonitorMetadata)v24;
                    if (!TransportIndexMonitorAction.this.getDocLevelMonitorQueries().docLevelQueryIndexExists(currentMonitor.getDataSources())) ** GOTO lbl168
                    $continuation.L$0 = currentMonitor;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.L$2 = indexResponse;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)failureReasons);
                    $continuation.L$4 = updatedMetadata;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                    $continuation.I$0 = isDocLevelMonitorRestarted;
                    $continuation.Z$0 = created;
                    $continuation.label = 4;
                    v25 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, onGetResponse$lambda$8(org.opensearch.alerting.transport.TransportIndexMonitorAction$IndexMonitorHandler org.opensearch.commons.alerting.model.Monitor org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexMonitorHandler)this, (Monitor)currentMonitor), (Continuation)$continuation);
                    ** if (v25 != var14_5) goto lbl154
lbl153:
                    // 1 sources

                    return var14_5;
lbl154:
                    // 1 sources

                    ** GOTO lbl168
                }
                case 4: {
                    created = $continuation.Z$0;
                    isDocLevelMonitorRestarted = $continuation.I$0;
                    metadata = (MonitorMetadata)$continuation.L$5;
                    updatedMetadata = (MonitorMetadata)$continuation.L$4;
                    failureReasons = (String)$continuation.L$3;
                    indexResponse = (IndexResponse)$continuation.L$2;
                    indexRequest = (IndexRequest)$continuation.L$1;
                    currentMonitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v25 = $result;
lbl168:
                    // 3 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentMonitor);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.L$2 = indexResponse;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)failureReasons);
                    $continuation.L$4 = updatedMetadata;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                    $continuation.I$0 = isDocLevelMonitorRestarted;
                    $continuation.Z$0 = created;
                    $continuation.label = 5;
                    v26 = this.indexDocLevelMonitorQueries(this.request.getMonitor(), currentMonitor.getId(), updatedMetadata, this.request.getRefreshPolicy(), (Continuation<? super Unit>)$continuation);
                    ** if (v26 != var14_5) goto lbl180
lbl179:
                    // 1 sources

                    return var14_5;
lbl180:
                    // 1 sources

                    ** GOTO lbl194
                }
                case 5: {
                    created = $continuation.Z$0;
                    isDocLevelMonitorRestarted = $continuation.I$0;
                    metadata = (MonitorMetadata)$continuation.L$5;
                    updatedMetadata = (MonitorMetadata)$continuation.L$4;
                    failureReasons = (String)$continuation.L$3;
                    indexResponse = (IndexResponse)$continuation.L$2;
                    indexRequest = (IndexRequest)$continuation.L$1;
                    currentMonitor = (Monitor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v26 = $result;
lbl194:
                    // 2 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentMonitor);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                    $continuation.L$2 = indexResponse;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)failureReasons);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)updatedMetadata);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)metadata);
                    $continuation.I$0 = isDocLevelMonitorRestarted;
                    $continuation.Z$0 = created;
                    $continuation.label = 6;
                    v27 = MonitorMetadataService.INSTANCE.upsertMetadata(updatedMetadata, true, (Continuation<? super MonitorMetadata>)$continuation);
                    ** if (v27 != var14_5) goto lbl206
lbl205:
                    // 1 sources

                    return var14_5;
lbl206:
                    // 1 sources

                    ** GOTO lbl220
                }
                case 6: {
                    created = $continuation.Z$0;
                    isDocLevelMonitorRestarted = $continuation.I$0;
                    metadata = (MonitorMetadata)$continuation.L$5;
                    updatedMetadata = (MonitorMetadata)$continuation.L$4;
                    failureReasons = (String)$continuation.L$3;
                    indexResponse = (IndexResponse)$continuation.L$2;
                    indexRequest = (IndexRequest)$continuation.L$1;
                    currentMonitor = (Monitor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v27 = $result;
lbl220:
                        // 4 sources

                        v28 = indexResponse.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"getId(...)");
                        this.actionListener.onResponse((Object)new IndexMonitorResponse(v28, indexResponse.getVersion(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), this.request.getMonitor()));
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"getFailures(...)");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        private static final Unit indexMonitor$lambda$4(IndexMonitorHandler this$0, IndexRequest $indexRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.client.index($indexRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit updateMonitor$lambda$5(IndexMonitorHandler this$0, GetRequest $getRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.client.get($getRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit onGetResponse$lambda$7(IndexMonitorHandler this$0, IndexRequest $indexRequest, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.client.index($indexRequest, it);
            return Unit.INSTANCE;
        }

        private static final Unit onGetResponse$lambda$8(IndexMonitorHandler this$0, Monitor $currentMonitor, Client $this$suspendUntil, ActionListener it) {
            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String[] stringArray = new String[]{$currentMonitor.getDataSources().getQueryIndex()};
            ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)new DeleteByQueryRequestBuilder((OpenSearchClient)this$0.client, (ActionType)DeleteByQueryAction.INSTANCE).source(stringArray)).filter((QueryBuilder)QueryBuilders.matchQuery((String)"monitor_id", (Object)$currentMonitor.getId()))).execute(it);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexMonitorHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexMonitorHandler $this, boolean isAcknowledged) {
            $this.onCreateMappingsResponse(isAcknowledged);
        }

        public static final /* synthetic */ Client access$getClient$p(IndexMonitorHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ void access$onUpdateMappingsResponse(IndexMonitorHandler $this, AcknowledgedResponse response2) {
            $this.onUpdateMappingsResponse(response2);
        }

        public static final /* synthetic */ Object access$updateMonitor(IndexMonitorHandler $this, Continuation $completion) {
            return $this.updateMonitor((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ void access$onSearchResponse(IndexMonitorHandler $this, SearchResponse response2) {
            $this.onSearchResponse(response2);
        }

        public static final /* synthetic */ Object access$indexMonitor(IndexMonitorHandler $this, Continuation $completion) {
            return $this.indexMonitor((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$cleanupMonitorAfterPartialFailure(IndexMonitorHandler $this, Monitor monitor, IndexResponse indexMonitorResponse2, Continuation $completion) {
            return $this.cleanupMonitorAfterPartialFailure(monitor, indexMonitorResponse2, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$indexDocLevelMonitorQueries(IndexMonitorHandler $this, Monitor monitor, String monitorId, MonitorMetadata monitorMetadata, WriteRequest.RefreshPolicy refreshPolicy, Continuation $completion) {
            return $this.indexDocLevelMonitorQueries(monitor, monitorId, monitorMetadata, refreshPolicy, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$onGetResponse(IndexMonitorHandler $this, Monitor currentMonitor, Continuation $completion) {
            return $this.onGetResponse(currentMonitor, (Continuation<? super Unit>)$completion);
        }
    }
}

