/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.sql.BFILE;
import oracle.sql.OPAQUE;

@ProxyFor(value={oracle.jdbc.internal.OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableStatement
extends TxnReplayableBase
implements JDBCReplayable,
OracleStatement.BindChecksumListener {
    private static final Method GETCLOB_METHOD = TxnReplayableStatement.getGetLobMethod("getClob", Integer.TYPE);
    private static final Method GETCLOB_WITH_NAME_METHOD = TxnReplayableStatement.getGetLobMethod("getClob", String.class);
    private static final Method GETNCLOB_METHOD = TxnReplayableStatement.getGetLobMethod("getNClob", Integer.TYPE);
    private static final Method GETNCLOB_WITH_NAME_METHOD = TxnReplayableStatement.getGetLobMethod("getNClob", String.class);
    private static final Method GETBLOB_METHOD = TxnReplayableStatement.getGetLobMethod("getBlob", Integer.TYPE);
    private static final Method GETBLOB_WITH_NAME_METHOD = TxnReplayableStatement.getGetLobMethod("getBlob", String.class);
    private static final Method GETBFILE_METHOD = TxnReplayableStatement.getGetLobMethod("getBfile", Integer.TYPE);
    private static final Method GETOBJECT_METHOD = TxnReplayableStatement.getMethod("getObject", Integer.TYPE);
    private static final Method GETOBJECT_WITH_TYPE_METHOD = TxnReplayableStatement.getMethod("getObject", Integer.TYPE, Class.class);
    private static final Method GETOBJECT_WITH_MAP_METHOD = TxnReplayableStatement.getMethod("getObject", Integer.TYPE, Map.class);
    private static final Method GETOBJECT_WITH_NAME_METHOD = TxnReplayableStatement.getMethod("getObject", String.class);
    private static final Method GETOBJECT_WITH_NAME_AND_TYPE_METHOD = TxnReplayableStatement.getMethod("getObject", String.class, Class.class);
    private static final Method GETOBJECT_WITH_NAME_AND_MAP_METHOD = TxnReplayableStatement.getMethod("getObject", String.class, Map.class);
    private static final Method GETREF_METHOD = TxnReplayableStatement.getMethod("getRef", Integer.TYPE);
    private static final Method GETREF_WITH_NAME_METHOD = TxnReplayableStatement.getMethod("getRef", String.class);
    private static final Method GETARRAY_METHOD = TxnReplayableStatement.getMethod("getArray", Integer.TYPE);
    private static final Method GETARRAY_WITH_NAME_METHOD = TxnReplayableStatement.getMethod("getArray", String.class);
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableStatement";

    protected TxnReplayableStatement() {
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args) {
        super.preForAll(m, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected void preForExecuteQuery(Method m, Object receiver, Object ... args) {
        this.preForAll(m, receiver, args);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case REPLAYING: {
                if (this.isSSSCursor) {
                    TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                    OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                    OracleStatement ostmt = (OracleStatement)this.getDelegate();
                    TxnFailoverManagerImpl.SSSCallHistoryEntry currentEntry = (TxnFailoverManagerImpl.SSSCallHistoryEntry)this.sssTailSameProxy;
                    TxnReplayableResultSet rsetProxy = (TxnReplayableResultSet)currentEntry.result;
                    try {
                        ostmt.markSSSCursor();
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecuteQuery", "On {0}, before replaying SSS-query, reposition cursor to: {1}", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), rsetProxy.sssFetchCount});
                        if (this.failoverMngr.sssFetchOutage) {
                            ostmt.setSSSCursorPosition(rsetProxy.sssFetchCount);
                        } else {
                            ostmt.setSSSCursorPosition(rsetProxy.sssFetchCount + 1);
                        }
                    }
                    catch (SQLException sqlexc) {
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecuteQuery", "On {0}, setting session state / cursor repositioning failed", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                    }
                }
            }
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement ostmt = (OracleStatement)this.getDelegate();
                    ostmt.registerBindChecksumListener(this);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecuteQuery", "On {0}, bind checksum listener registered", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                catch (SQLException sqlexc) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecuteQuery", "On {0}, bind checksum listener registration failed", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method m, Object receiver, Object ... args) {
        this.preForAll(m, receiver, args);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case REPLAYING: 
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement ostmt = (OracleStatement)this.getDelegate();
                    ostmt.registerBindChecksumListener(this);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecute", "On {0}, bind checksum listener registered", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                catch (SQLException sqlexc) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecute", "On {0}, bind checksum listener registration failed", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method m, Object receiver, Object ... args) {
        this.preForAll(m, receiver, args);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case REPLAYING: 
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement ostmt = (OracleStatement)this.getDelegate();
                    ostmt.registerBindChecksumListener(this);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecuteUpdate", "On {0}, bind checksum listener registered", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                catch (SQLException sqlexc) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForExecuteUpdate", "On {0}, bind checksum listener registration failed", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="sendBatch", args={}), @Signature(name="executeBatch", args={})})
    protected void preForBatches(Method m, Object receiver, Object ... args) {
        this.preForAll(m, receiver, args);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case REPLAYING: 
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement ostmt = (OracleStatement)this.getDelegate();
                    ostmt.registerBindChecksumListener(this);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForBatches", "On {0}, bind checksum listener registered", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                catch (SQLException sqlexc) {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForBatches", "On {0}, bind checksum listener registration failed", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                }
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="getOPAQUE", args={int.class}), @Signature(name="setOPAQUE", args={String.class, OPAQUE.class}), @Signature(name="setOPAQUE", args={int.class, OPAQUE.class}), @Signature(name="setOPAQUEAtName", args={String.class, OPAQUE.class})})
    protected void preForMethodWithConcreteClass(Method m, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForMethodWithConcreteClass", "On {0}, DISABLE REPLAY in preForMethodWithConcreteClass({1})", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 397, "Replay disabled because of concrete class usage", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForMethodWithConcreteClass", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setBlob", args={String.class, InputStream.class}), @Signature(name="setBlob", args={String.class, InputStream.class, long.class}), @Signature(name="setClob", args={String.class, Reader.class}), @Signature(name="setClob", args={String.class, Reader.class, long.class}), @Signature(name="setNClob", args={String.class, Reader.class}), @Signature(name="setNClob", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setUnicodeStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBlob", args={int.class, InputStream.class}), @Signature(name="setBlob", args={int.class, InputStream.class, long.class}), @Signature(name="setClob", args={int.class, Reader.class}), @Signature(name="setClob", args={int.class, Reader.class, long.class}), @Signature(name="setNClob", args={int.class, Reader.class}), @Signature(name="setNClob", args={int.class, Reader.class, long.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBlobAtName", args={String.class, InputStream.class}), @Signature(name="setBlobAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setClobAtName", args={String.class, Reader.class}), @Signature(name="setClobAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNClobAtName", args={String.class, Reader.class}), @Signature(name="setNClobAtName", args={String.class, Reader.class, long.class})})
    protected void preForSetStreams(Method m, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForSetStreams", "On statement {0}, preForSetStreams", (String)null, (Throwable)null, (Object)this.hashCode());
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForSetStreams", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setObject", args={String.class, Object.class}), @Signature(name="setObject", args={String.class, Object.class, int.class}), @Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @Signature(name="setObject", args={int.class, Object.class}), @Signature(name="setObject", args={int.class, Object.class, int.class}), @Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
    protected void preForSetObjects(Method m, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForSetObjects", "On statement {0}, preForSetObjects", (String)null, (Throwable)null, (Object)this.hashCode());
        if (args[1] instanceof InputStream || args[1] instanceof Reader) {
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
            } else {
                this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForSetObjects", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
            }
        } else {
            this.preForAll(m, receiver, args);
        }
    }

    @Override
    @Post
    protected void postForAll(Method m) {
        this.postForAll(m, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result) {
        return super.postForAll(m, result);
    }

    @Post
    @Methods(signatures={@Signature(name="getResultSet", args={})})
    protected ResultSet postForGetResultSet(Method m, ResultSet result) {
        this.postForAll(m, result);
        if (!this.failoverMngr.isSessionStateConsistencyDynamic()) {
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    TxnFailoverManagerImpl.CallHistoryEntry entry = this.tailSameProxy;
                    while (entry != this.headSameProxy) {
                        if ("execute".equals(entry.method.getName()) && entry.result instanceof Integer) {
                            ((TxnReplayableResultSet)((Object)result)).creatorCallEntry = entry;
                        }
                        entry = entry.prevEntrySameProxy;
                    }
                    break;
                }
            }
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method m, ResultSet result) {
        this.postForAll(m, result);
        if (!this.failoverMngr.isSessionStateConsistencyDynamic() || this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled) {
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    if (!this.failoverMngr.isSessionStateConsistencyDynamic()) {
                        ((TxnReplayableResultSet)((Object)result)).creatorCallEntry = this.tailSameProxy;
                        break;
                    }
                    if (this.isSSSCursor) {
                        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                        OracleStatement ostmt = (OracleStatement)this.getDelegate();
                        try {
                            if (!ostmt.allRowsFetched()) {
                                this.copyFromMainToSSSQueue();
                            }
                            ((TxnReplayableResultSet)((Object)result)).creatorCallEntry = this.tailSameProxy;
                            ((TxnReplayableResultSet)((Object)result)).isSSSCursor = this.isSSSCursor;
                            if (!ostmt.allRowsFetched()) {
                                TxnFailoverManagerImpl.SSSCallHistoryEntry currentEntry = (TxnFailoverManagerImpl.SSSCallHistoryEntry)this.sssTailSameProxy;
                                currentEntry.stateBeforeExec = oconn.getDatabaseSessionState();
                                currentEntry.sssChecksum = ostmt.getSSSCursorChecksum();
                                currentEntry.fetchedRowsCount = ostmt.getRowPrefetch();
                                connProxy.checkImplicitRequestBoundary();
                            }
                        }
                        catch (SQLException sqlexc) {
                            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForExecuteQuery", "On {0}, getting session state / SSS-cursor checksum failed", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                        }
                    }
                    this.headSameProxy = null;
                    this.tailSameProxy = null;
                    break;
                }
                case REPLAYING: {
                    if (!this.isSSSCursor) break;
                    TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                    OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                    OracleStatement ostmt = (OracleStatement)this.getDelegate();
                    try {
                        long replaySSSChecksum = ostmt.getSSSCursorChecksum();
                        TxnFailoverManagerImpl.SSSCallHistoryEntry sSSCallHistoryEntry = (TxnFailoverManagerImpl.SSSCallHistoryEntry)this.sssTailSameProxy;
                    }
                    catch (SQLException sqlexc) {
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForExecuteQuery", "On {0}, getting SSS-cursor checksum failed", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                    }
                    break;
                }
            }
        }
        return result;
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(int paramIndex) throws SQLException {
        if (GETCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(int)");
        }
        Method m = GETCLOB_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Clob result = ocstmt.getClob(paramIndex);
            return (Clob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Clob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(String paramName) throws SQLException {
        if (GETCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(String)");
        }
        Method m = GETCLOB_WITH_NAME_METHOD;
        this.preForAll(m, this, paramName);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Clob result = ocstmt.getClob(paramName);
            return (Clob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Clob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(int paramIndex) throws SQLException {
        if (GETNCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(int)");
        }
        Method m = GETNCLOB_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            NClob result = ocstmt.getNClob(paramIndex);
            return (NClob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (NClob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(String paramName) throws SQLException {
        if (GETNCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(String)");
        }
        Method m = GETNCLOB_WITH_NAME_METHOD;
        this.preForAll(m, this, paramName);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            NClob result = ocstmt.getNClob(paramName);
            return (NClob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (NClob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(int paramIndex) throws SQLException {
        if (GETBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(int)");
        }
        Method m = GETBLOB_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Blob result = ocstmt.getBlob(paramIndex);
            return (Blob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Blob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(String paramName) throws SQLException {
        if (GETBLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(String)");
        }
        Method m = GETBLOB_WITH_NAME_METHOD;
        this.preForAll(m, this, paramName);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Blob result = ocstmt.getBlob(paramName);
            return (Blob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Blob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(int paramIndex) throws SQLException {
        if (GETBFILE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(int)");
        }
        Method m = GETBFILE_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            OracleCallableStatement ocstmt = (OracleCallableStatement)this.getDelegate();
            BFILE result = ocstmt.getBfile(paramIndex);
            return (BFILE)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (BFILE)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int paramIndex) throws SQLException {
        if (GETOBJECT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int)");
        }
        Method m = GETOBJECT_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            ProxyFactory pxyFactory;
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Object result = ocstmt.getObject(paramIndex);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(int paramIndex, Class<T> type) throws SQLException {
        if (GETOBJECT_WITH_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int,Class<T>)");
        }
        Method m = GETOBJECT_WITH_TYPE_METHOD;
        this.preForAll(m, this, paramIndex, type);
        try {
            ProxyFactory pxyFactory;
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            T result = ocstmt.getObject(paramIndex, type);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return (T)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (T)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int paramIndex, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int, Map)");
        }
        Method m = GETOBJECT_WITH_MAP_METHOD;
        this.preForAll(m, this, paramIndex, map);
        try {
            ProxyFactory pxyFactory;
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Object result = ocstmt.getObject(paramIndex, map);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String paramName) throws SQLException {
        if (GETOBJECT_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String)");
        }
        Method m = GETOBJECT_WITH_NAME_METHOD;
        this.preForAll(m, this, paramName);
        try {
            ProxyFactory pxyFactory;
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Object result = ocstmt.getObject(paramName);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(String paramName, Class<T> type) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String,Class<T>)");
        }
        Method m = GETOBJECT_WITH_NAME_AND_TYPE_METHOD;
        this.preForAll(m, this, paramName, type);
        try {
            ProxyFactory pxyFactory;
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            T result = ocstmt.getObject(paramName, type);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return (T)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (T)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String paramName, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String, Map)");
        }
        Method m = GETOBJECT_WITH_NAME_AND_MAP_METHOD;
        this.preForAll(m, this, paramName, map);
        try {
            ProxyFactory pxyFactory;
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Object result = ocstmt.getObject(paramName, map);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(int paramIndex) throws SQLException {
        if (GETREF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(int)");
        }
        Method m = GETREF_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Ref result = ocstmt.getRef(paramIndex);
            return (Ref)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Ref)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(String paramName) throws SQLException {
        if (GETREF_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(String)");
        }
        Method m = GETREF_WITH_NAME_METHOD;
        this.preForAll(m, this, paramName);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Ref result = ocstmt.getRef(paramName);
            return (Ref)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Ref)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(int paramIndex) throws SQLException {
        if (GETARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(int)");
        }
        Method m = GETARRAY_METHOD;
        this.preForAll(m, this, paramIndex);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Array result = ocstmt.getArray(paramIndex);
            return (Array)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Array)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(String paramName) throws SQLException {
        if (GETARRAY_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(String)");
        }
        Method m = GETARRAY_WITH_NAME_METHOD;
        this.preForAll(m, this, paramName);
        try {
            CallableStatement ocstmt = (CallableStatement)this.getDelegate();
            Array result = ocstmt.getArray(paramName);
            return (Array)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Array)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    private static final Method getGetLobMethod(String methodName, Class<?> argType) {
        try {
            return oracle.jdbc.internal.OracleCallableStatement.class.getMethod(methodName, argType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            return oracle.jdbc.internal.OracleCallableStatement.class.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m) {
        this.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
            this.isLogicallyClosed = true;
            if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled) {
                this.headSameProxy = null;
                this.tailSameProxy = null;
                this.creatorCallEntry = null;
                if (this.isSSSCursor && this.sssCreatorCallEntry != null) {
                    this.purgeFromSSSQueue();
                }
            }
            if (!this.isSSSCursor) {
                try {
                    connProxy.checkImplicitRequestBoundary();
                }
                catch (Throwable error) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForClose", "On {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                }
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method m, SQLException error) throws SQLException {
        if (error instanceof SQLRecoverableException) {
            return;
        }
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public boolean shouldContinue(long checksum) {
        boolean retValue = true;
        TxnFailoverManagerImpl.CallHistoryEntry currentExecEntry = this.failoverMngr.getCallHistoryTail();
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.currentBindChecksum = checksum;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "shouldContinue", "On {0}, bind checksum: {1}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), checksum});
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                if (currentExecEntry.checksum == 0L) break;
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "shouldContinue", "On {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), currentExecEntry.method.getName(), checksum, currentExecEntry.checksum});
                if (currentExecEntry.checksum == checksum) break;
                this.failoverMngr.disableReplayInternal(currentExecEntry.method, 388, "Replay failed because of checksum mismatch", null);
                retValue = false;
            }
        }
        currentExecEntry = null;
        return retValue;
    }
}

