/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import jakarta.persistence.metamodel.Type;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class BasicValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements Assignable,
DomainResultProducer<T> {
    private final ColumnReference columnReference;
    private final @Nullable String affectedTableName;

    public static <T> BasicValuedPathInterpretation<T> from(SqmBasicValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState, boolean jpaQueryComplianceEnabled) {
        Object treatTarget;
        Object modelPartContainer;
        SqmTreatedPath treatedPath;
        SqlAstCreationContext creationContext = sqlAstCreationState.getCreationContext();
        JpaPath lhs = sqmPath.getLhs();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(lhs.getNavigablePath());
        ModelPartContainer tableGroupModelPart = tableGroup.getModelPart();
        MappingMetamodelImplementor mappingMetamodel = creationContext.getMappingMetamodel();
        if (lhs instanceof SqmTreatedPath && (treatedPath = (SqmTreatedPath)lhs).getTreatTarget().getPersistenceType() == Type.PersistenceType.ENTITY) {
            EntityMappingType entityMappingType;
            EntityDomainType treatTargetDomainType = (EntityDomainType)treatedPath.getTreatTarget();
            treatEntityDescriptor = mappingMetamodel.findEntityDescriptor(treatTargetDomainType.getHibernateEntityName());
            MappingType mappingType = tableGroupModelPart.getPartMappingType();
            if (mappingType instanceof EntityMappingType && treatEntityDescriptor.isTypeOrSuperType(entityMappingType = (EntityMappingType)mappingType)) {
                modelPartContainer = tableGroupModelPart;
                treatTarget = treatEntityDescriptor;
            } else {
                modelPartContainer = treatEntityDescriptor;
                treatTarget = null;
            }
        } else {
            EntityPersister entityPersister;
            modelPartContainer = tableGroupModelPart;
            if (jpaQueryComplianceEnabled && (treatEntityDescriptor = lhs.getNodeType()) instanceof EntityDomainType) {
                EntityDomainType entityDomainType = (EntityDomainType)treatEntityDescriptor;
                entityPersister = mappingMetamodel.findEntityDescriptor(entityDomainType.getHibernateEntityName());
            } else {
                entityPersister = null;
            }
            treatTarget = entityPersister;
        }
        ModelPart modelPart = SqmUtil.getTargetMappingIfNeeded(sqmPath, (ModelPartContainer)modelPartContainer, sqlAstCreationState).findSubPart(sqmPath.getReferencedPathSource().getPathName(), (EntityMappingType)treatTarget);
        if (modelPart == null) {
            BasicValuedPathInterpretation.modelPartError(sqmPath, jpaQueryComplianceEnabled, tableGroup);
        }
        NavigablePath navigablePath = sqmPath.getNavigablePath();
        BasicValuedModelPart mapping = NullnessUtil.castNonNull(modelPart.asBasicValuedModelPart());
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath, mapping, mapping.getContainingTableExpression());
        Expression expression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, mapping);
        return new BasicValuedPathInterpretation<T>(BasicValuedPathInterpretation.columnReference(expression), navigablePath, mapping, tableGroup);
    }

    private static <T> void modelPartError(SqmBasicValuedSimplePath<T> sqmPath, boolean jpaQueryComplianceEnabled, TableGroup tableGroup) {
        ModelPart subPart;
        if (jpaQueryComplianceEnabled && (subPart = tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null)) != null) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.IMPLICIT_TREAT);
        }
        throw new UnknownPathException("Path '" + String.valueOf(sqmPath.getNavigablePath()) + "' did not reference a known model part");
    }

    private static ColumnReference columnReference(Expression expression) {
        if (expression instanceof ColumnReference) {
            ColumnReference reference = (ColumnReference)expression;
            return reference;
        }
        if (expression instanceof SqlSelectionExpression) {
            SqlSelectionExpression selection = (SqlSelectionExpression)expression;
            Expression selectedExpression = selection.getSelection().getExpression();
            assert (selectedExpression instanceof ColumnReference);
            return (ColumnReference)selectedExpression;
        }
        throw new UnsupportedOperationException("Unsupported basic-valued path expression : " + String.valueOf(expression));
    }

    public BasicValuedPathInterpretation(ColumnReference columnReference, NavigablePath navigablePath, BasicValuedModelPart mapping, TableGroup tableGroup) {
        this(columnReference, navigablePath, mapping, tableGroup, SqmUtil.determineAffectedTableName(tableGroup, mapping));
    }

    public BasicValuedPathInterpretation(ColumnReference columnReference, NavigablePath navigablePath, BasicValuedModelPart mapping, TableGroup tableGroup, @Nullable String affectedTableName) {
        super(navigablePath, mapping, tableGroup);
        assert (columnReference != null);
        this.columnReference = columnReference;
        this.affectedTableName = affectedTableName;
    }

    @Override
    public Expression getSqlExpression() {
        return this.columnReference;
    }

    @Override
    public @Nullable String getAffectedTableName() {
        return this.affectedTableName;
    }

    @Override
    public ColumnReference getColumnReference() {
        return this.columnReference;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.columnReference.accept(sqlTreeWalker);
    }

    public String toString() {
        return "BasicValuedPathInterpretation(" + String.valueOf(this.getNavigablePath()) + ")";
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this.columnReference);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this.columnReference);
    }
}

