/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.FlushModeType;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;

public enum FlushMode {
    MANUAL,
    COMMIT,
    AUTO,
    ALWAYS;


    public boolean lessThan(FlushMode other) {
        return this.level() < other.level();
    }

    public static FlushMode interpretExternalSetting(String externalName) {
        return FlushModeTypeHelper.interpretExternalSetting(externalName);
    }

    private int level() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 3 -> 20;
            case 2 -> 10;
            case 1 -> 5;
            case 0 -> 0;
        };
    }

    public static FlushMode fromJpaFlushMode(FlushModeType flushModeType) {
        return FlushModeTypeHelper.getFlushMode(flushModeType);
    }

    public static FlushModeType toJpaFlushMode(FlushMode flushMode) {
        return FlushModeTypeHelper.getFlushModeType(flushMode);
    }

    public FlushModeType toJpaFlushMode() {
        return FlushModeTypeHelper.getFlushModeType(this);
    }
}

