/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;

public final class RequestEngine {
    private static final JVM jvm = JVM.getJVM();
    private static final List<RequestHook> entries = new CopyOnWriteArrayList<RequestHook>();
    private static long lastTimeMillis;

    public static void addHook(AccessControlContext accessControlContext, PlatformEventType platformEventType, Runnable runnable) {
        Objects.requireNonNull(accessControlContext);
        RequestEngine.addHookInternal(accessControlContext, platformEventType, runnable);
    }

    private static void addHookInternal(AccessControlContext accessControlContext, PlatformEventType platformEventType, Runnable runnable) {
        RequestHook requestHook = new RequestHook(accessControlContext, platformEventType, runnable);
        for (RequestHook requestHook2 : entries) {
            if (requestHook2.hook != runnable) continue;
            throw new IllegalArgumentException("Hook has already been added");
        }
        requestHook.type.setEventHook(true);
        entries.add(requestHook);
        RequestEngine.logHook("Added", platformEventType);
    }

    public static void addTrustedJDKHook(Class<? extends Event> clazz, Runnable runnable) {
        if (clazz.getClassLoader() != null) {
            throw new SecurityException("Hook can only be registered for event classes that are loaded by the bootstrap class loader");
        }
        if (runnable.getClass().getClassLoader() != null) {
            throw new SecurityException("Runnable hook class must be loaded by the bootstrap class loader");
        }
        EventType eventType = MetadataRepository.getInstance().getEventType(clazz);
        PlatformEventType platformEventType = PrivateAccess.getInstance().getPlatformEventType(eventType);
        RequestEngine.addHookInternal(null, platformEventType, runnable);
    }

    private static void logHook(String string, PlatformEventType platformEventType) {
        if (platformEventType.isJDK() || platformEventType.isJVM()) {
            Logger.log(LogTag.JFR_SYSTEM_EVENT, LogLevel.INFO, string + " periodic hook for " + platformEventType.getLogName());
        } else {
            Logger.log(LogTag.JFR_EVENT, LogLevel.INFO, string + " periodic hook for " + platformEventType.getLogName());
        }
    }

    public static boolean removeHook(Runnable runnable) {
        for (RequestHook requestHook : entries) {
            if (requestHook.hook != runnable) continue;
            entries.remove(requestHook);
            requestHook.type.setEventHook(false);
            RequestEngine.logHook("Removed", requestHook.type);
            return true;
        }
        return false;
    }

    static void addHooks(List<RequestHook> list) {
        ArrayList<RequestHook> arrayList = new ArrayList<RequestHook>();
        for (RequestHook requestHook : list) {
            requestHook.type.setEventHook(true);
            arrayList.add(requestHook);
            RequestEngine.logHook("Added", requestHook.type);
        }
        entries.addAll(list);
    }

    static void doChunkEnd() {
        RequestEngine.doChunk(platformEventType -> platformEventType.isEndChunk());
    }

    static void doChunkBegin() {
        RequestEngine.doChunk(platformEventType -> platformEventType.isBeginChunk());
    }

    private static void doChunk(Predicate<PlatformEventType> predicate) {
        for (RequestHook requestHook : entries) {
            PlatformEventType platformEventType = requestHook.type;
            if (!platformEventType.isEnabled() || !predicate.test(platformEventType)) continue;
            requestHook.execute();
        }
    }

    static long doPeriodic() {
        return RequestEngine.run_requests(entries);
    }

    private static long run_requests(Collection<RequestHook> collection) {
        long l = lastTimeMillis;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        if (l == 0L) {
            l = l2;
        }
        if ((l4 = l2 - l) < 0L) {
            lastTimeMillis = l2;
            return 0L;
        }
        for (RequestHook requestHook : collection) {
            long l5 = 0L;
            PlatformEventType platformEventType = requestHook.type;
            if (!platformEventType.isEnabled() || platformEventType.isEveryChunk()) continue;
            long l6 = platformEventType.getPeriod();
            long l7 = requestHook.delta;
            if ((l7 += l4) >= l6) {
                l7 = 0L;
                requestHook.execute();
            }
            if ((l5 = l6 - l7) < 0L) {
                l5 = 0L;
            }
            requestHook.delta = l7;
            if (l3 != 0L && l5 >= l3) continue;
            l3 = l5;
        }
        lastTimeMillis = l2;
        return l3;
    }

    static final class RequestHook {
        private final Runnable hook;
        private final PlatformEventType type;
        private final AccessControlContext accessControllerContext;
        private long delta;

        private RequestHook(AccessControlContext accessControlContext, PlatformEventType platformEventType, Runnable runnable) {
            this.hook = runnable;
            this.type = platformEventType;
            this.accessControllerContext = accessControlContext;
        }

        RequestHook(PlatformEventType platformEventType) {
            this(null, platformEventType, null);
        }

        private void execute() {
            try {
                if (this.accessControllerContext == null) {
                    if (this.type.isJDK()) {
                        this.hook.run();
                    } else {
                        jvm.emitEvent(this.type.getId(), JVM.counterTime(), 0L);
                    }
                    if (Logger.shouldLog(LogTag.JFR_EVENT, LogLevel.DEBUG)) {
                        Logger.log(LogTag.JFR_SYSTEM_EVENT, LogLevel.DEBUG, () -> "Executed periodic hook for " + this.type.getLogName());
                    }
                } else {
                    this.executeSecure();
                }
            }
            catch (Throwable throwable) {
                Logger.log(LogTag.JFR_SYSTEM_EVENT, LogLevel.WARN, "Exception occured during execution of period hook for " + this.type.getLogName());
            }
        }

        private void executeSecure() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        hook.run();
                        if (Logger.shouldLog(LogTag.JFR_EVENT, LogLevel.DEBUG)) {
                            Logger.log(LogTag.JFR_EVENT, LogLevel.DEBUG, () -> "Executed periodic hook for " + type.getLogName());
                        }
                    }
                    catch (Throwable throwable) {
                        Logger.log(LogTag.JFR_EVENT, LogLevel.WARN, "Exception occured during execution of period hook for " + type.getLogName());
                    }
                    return null;
                }
            }, this.accessControllerContext);
        }
    }
}

