/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.util.ArrayList;
import java.util.List;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.ReverseRangeCmd;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.TimeSensitiveFunction;

public class ReverseSelectedRange
extends TimeSensitiveFunction {
    public ReverseSelectedRange(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.reverserange";
    }

    @Override
    public void begin() {
        if (!this.confirmTimestampMangling()) {
            return;
        }
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        if (n < 0 || n2 <= n) {
            return;
        }
        Track track = this._app.getTrackInfo().getTrack();
        Command command = ReverseSelectedRange.makeReverseCommand(track, n, n2);
        command.setDescription(this.getName());
        command.setConfirmText(I18nManager.getText("confirm.reverserange"));
        this._app.execute(command);
    }

    public static Command makeReverseCommand(Track track, int n, int n2) {
        List<Integer> list = ReverseSelectedRange.makeNewOrdering(track.getNumPoints(), n, n2);
        ArrayList<PointFlag> arrayList = null;
        if (track.isTrackPointWithin(n, n2)) {
            arrayList = new ArrayList<PointFlag>();
            arrayList.add(new PointFlag(track.getNextTrackPoint(n2 + 1), true));
            boolean bl = true;
            int n3 = n2;
            while (n3 >= n) {
                DataPoint dataPoint = track.getPoint(n3);
                if (!dataPoint.isWaypoint()) {
                    arrayList.add(new PointFlag(dataPoint, bl));
                    bl = dataPoint.getSegmentStart();
                }
                --n3;
            }
        }
        return new ReverseRangeCmd(list, arrayList);
    }

    private static List<Integer> makeNewOrdering(int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = 0;
        while (n4 < n2) {
            arrayList.add(n4);
            ++n4;
        }
        n4 = n3;
        while (n4 >= n2) {
            arrayList.add(n4);
            --n4;
        }
        n4 = n3 + 1;
        while (n4 < n) {
            arrayList.add(n4);
            ++n4;
        }
        return arrayList;
    }
}

