/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.JViewport;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.WrapLayout;

public class BuildingsLayoutManager
implements LayoutManager {
    private long layoutSeed = 1L;
    private WrapLayout wrapLayout = new WrapLayout();

    public BuildingsLayoutManager() {
        this(1L);
    }

    public BuildingsLayoutManager(long layoutSeed) {
        this.layoutSeed = layoutSeed;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = this.determineInitialSize(parent);
        if (this.randomizedPlacement(parent, size, true)) {
            return size;
        }
        this.setAllEmptyBuildingSiteVisibility(parent, false);
        return this.wrapLayout.layoutSize(parent, size.width, false);
    }

    private Dimension determineInitialSize(Container parent) {
        if (parent.getParent() != null && parent.getParent() instanceof JViewport) {
            return parent.getParent().getSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension newSize;
            Dimension size = parent.getSize();
            boolean skipRandomizedPlacement = false;
            if (parent.getParent() != null && parent.getParent() instanceof JViewport && !size.equals(newSize = parent.getParent().getSize())) {
                skipRandomizedPlacement = true;
            }
            if (!skipRandomizedPlacement) {
                this.setAllEmptyBuildingSiteVisibility(parent, true);
                if (this.randomizedPlacement(parent, size, false)) {
                    return;
                }
            }
            this.setAllEmptyBuildingSiteVisibility(parent, false);
            this.wrapLayout.layoutContainer(parent, false);
        }
    }

    private void setAllEmptyBuildingSiteVisibility(Container parent, boolean visible) {
        for (Component c : parent.getComponents()) {
            if (!(c instanceof ColonyPanel.BuildingsPanel.EmptyBuildingSite)) continue;
            c.setVisible(visible);
        }
    }

    private boolean randomizedPlacement(Container parent, Dimension size, boolean dryRun) {
        Random r = new Random(this.layoutSeed);
        List<Entry> entries = this.getAllEntries(parent, size);
        if (this.isDefinitelyNotEnoughRoomForLayout(entries, size)) {
            return false;
        }
        this.sortWithLargestFirst(entries);
        int MAX_TOTAL_TRIES = 24;
        int MAX_FREE_PLACEMENT = 6;
        int MAX_PLACE_ENTRY = 10000;
        int padding = 16;
        for (int j = 0; j < 24; ++j) {
            ArrayList<Rectangle> usedRectangles = new ArrayList<Rectangle>(entries.size());
            List<Entry> placeEntries = j > 6 ? this.placeFirstFourEntriesInTheCorners(size, entries, usedRectangles) : entries;
            int entriesRemaining = placeEntries.size();
            for (Entry entry : placeEntries) {
                boolean placed = false;
                for (int i = 0; i < 10000 / (entriesRemaining * entriesRemaining); ++i) {
                    int y;
                    int x = r.nextInt(size.width - entry.bounds.width);
                    Rectangle bounds = new Rectangle(x, y = r.nextInt(size.height - entry.bounds.height), entry.bounds.width, entry.bounds.height);
                    if (this.overlaps(bounds, usedRectangles)) continue;
                    usedRectangles.add(new Rectangle(bounds.x - padding / 2, bounds.y - padding / 2, bounds.width + padding, bounds.height + padding));
                    entry.bounds = bounds;
                    placed = true;
                    break;
                }
                if (!placed) break;
                --entriesRemaining;
            }
            if (entriesRemaining == 0) {
                if (!dryRun) {
                    for (Entry entry : entries) {
                        entry.component.setBounds(entry.bounds);
                    }
                }
                return true;
            }
            if ((padding /= 2) >= 0) continue;
            padding = 0;
        }
        return false;
    }

    private List<Entry> placeFirstFourEntriesInTheCorners(Dimension size, List<Entry> entries, List<Rectangle> usedRectangles) {
        Entry e0 = entries.get(0);
        Entry e1 = entries.get(1);
        Entry e2 = entries.get(2);
        Entry e3 = entries.get(3);
        e0.bounds = new Rectangle(0, 0, e0.bounds.width, e0.bounds.height);
        usedRectangles.add(e0.bounds);
        e1.bounds = new Rectangle(0, size.height - e1.bounds.height, e1.bounds.width, e1.bounds.height);
        usedRectangles.add(e1.bounds);
        e2.bounds = new Rectangle(size.width - e1.bounds.width, 0, e2.bounds.width, e2.bounds.height);
        usedRectangles.add(e2.bounds);
        e3.bounds = new Rectangle(size.width - e3.bounds.width, size.height - e3.bounds.height, e3.bounds.width, e3.bounds.height);
        usedRectangles.add(e3.bounds);
        return entries.subList(4, entries.size());
    }

    private boolean isDefinitelyNotEnoughRoomForLayout(List<Entry> entries, Dimension size) {
        if (entries.isEmpty()) {
            return false;
        }
        long minimumArea = entries.stream().map(BuildingsLayoutManager::areaOf).reduce((a, b) -> a + b).get();
        return minimumArea > (long)size.width * (long)size.height;
    }

    private List<Entry> getAllEntries(Container parent, Dimension size) {
        ArrayList<Entry> entries = new ArrayList<Entry>(parent.getComponentCount());
        for (Component c : parent.getComponents()) {
            if (!c.isVisible()) continue;
            Dimension componentSize = c.getPreferredSize();
            entries.add(new Entry(c, new Rectangle(0, 0, componentSize.width, componentSize.height)));
        }
        return entries;
    }

    private void sortWithLargestFirst(List<Entry> entries) {
        Collections.sort(entries, (a, b) -> Long.compare(BuildingsLayoutManager.areaOf(b), BuildingsLayoutManager.areaOf(a)));
    }

    private static long areaOf(Entry a) {
        return (long)a.bounds.width * (long)a.bounds.height;
    }

    private boolean overlaps(Rectangle rectangle, List<Rectangle> list) {
        for (Rectangle r : list) {
            if (!rectangle.intersects(r)) continue;
            return true;
        }
        return false;
    }

    final Point determineOffsetForCentering(Dimension displaySize, Dimension contentSize) {
        return new Point((displaySize.width - contentSize.width) / 2, (displaySize.height - contentSize.height) / 2);
    }

    final Rectangle reposition(Rectangle bounds, Point offset) {
        return new Rectangle(bounds.x + offset.x, bounds.y + offset.y, bounds.width, bounds.height);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private static class Entry {
        private Component component;
        private Rectangle bounds;

        public Entry(Component component, Rectangle bounds) {
            this.component = component;
            this.bounds = bounds;
        }
    }
}

