/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.joda.convert.TypeUtils;
import org.joda.convert.TypedStringConverter;

final class TypeTokenStringConverter
implements TypedStringConverter<Object> {
    static final Class<?> TYPE_TOKEN_CLASS;
    static final Method TYPE_TOKEN_METHOD_OF;

    TypeTokenStringConverter() {
    }

    @Override
    public String convertToString(Object object) {
        return object.toString();
    }

    @Override
    public Object convertFromString(Class<?> cls, String str) {
        Type parsed = TypeUtils.parse(str);
        try {
            return TYPE_TOKEN_METHOD_OF.invoke(null, parsed);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Class<?> getEffectiveType() {
        return TYPE_TOKEN_CLASS;
    }

    static {
        try {
            TYPE_TOKEN_CLASS = Class.forName("com.google.common.reflect.TypeToken");
            TYPE_TOKEN_METHOD_OF = TYPE_TOKEN_CLASS.getDeclaredMethod("of", Type.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

