﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm/SSM_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSM {
namespace Model {
class CreateActivationResult {
 public:
  AWS_SSM_API CreateActivationResult() = default;
  AWS_SSM_API CreateActivationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSM_API CreateActivationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID number generated by the system when it processed the activation. The
   * activation ID functions like a user name.</p>
   */
  inline const Aws::String& GetActivationId() const { return m_activationId; }
  template <typename ActivationIdT = Aws::String>
  void SetActivationId(ActivationIdT&& value) {
    m_activationIdHasBeenSet = true;
    m_activationId = std::forward<ActivationIdT>(value);
  }
  template <typename ActivationIdT = Aws::String>
  CreateActivationResult& WithActivationId(ActivationIdT&& value) {
    SetActivationId(std::forward<ActivationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The code the system generates when it processes the activation. The
   * activation code functions like a password to validate the activation ID. </p>
   */
  inline const Aws::String& GetActivationCode() const { return m_activationCode; }
  template <typename ActivationCodeT = Aws::String>
  void SetActivationCode(ActivationCodeT&& value) {
    m_activationCodeHasBeenSet = true;
    m_activationCode = std::forward<ActivationCodeT>(value);
  }
  template <typename ActivationCodeT = Aws::String>
  CreateActivationResult& WithActivationCode(ActivationCodeT&& value) {
    SetActivationCode(std::forward<ActivationCodeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateActivationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_activationId;

  Aws::String m_activationCode;

  Aws::String m_requestId;
  bool m_activationIdHasBeenSet = false;
  bool m_activationCodeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSM
}  // namespace Aws
